/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.split;

import java.text.MessageFormat;
import java.util.concurrent.Semaphore;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;

public class SyncSplitTempCleanService
extends SplitTaskServiceAbst {
    private WriterConfiguration configuration;

    public SyncSplitTempCleanService(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.TEMPCLEAN);
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitTempCleanService doArchive begin,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        long cnt = 0L;
        String mainSeqMvTable = ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq());
        if (!this.mp.isCurStepExecuted()) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select count(*) from ").append(mainSeqMvTable);
            cnt = (Long)DB.query((DBRoute)this.configuration.getRoute(), (String)sql.toString(), rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
            Semaphore sp = this.configuration.getSplitTempCleanSemaphore();
            sp.acquire();
            try {
                ArchiveTaskRepository.get().incTotalCount(this.configuration.getTaskEntity().getId(), cnt);
                this.mp.setCurStepExecuted(true);
                this.mp.store(false);
            }
            finally {
                sp.release();
            }
        }
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            String pkmTable = ArchiveName.of((String)archiveConfig.getTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq());
            TableManager.get().dropTable(this.configuration.getRoute(), pkmTable);
        }
        for (ArchiveConfig ac : this.configuration.getConfigs()) {
            String tranTable = ArchiveName.of((String)ac.getTable()).getArchiveTranTable((long)this.splitTaskEntity.getSeq());
            TableManager.get().dropTable(this.configuration.getRoute(), tranTable);
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SyncSplitTempCleanService doArchive end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }
}

