/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.taskgroup.Writer;
import kd.bos.archive.transport.exchanger.RecordReceiver;
import kd.bos.archive.transport.record.Record;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.MCArchive;

public abstract class SyncWriterAbst
implements Writer {
    protected IProgress progress;
    protected int bufferSize;
    protected DBType dbType;
    protected WriterConfiguration configuration;

    public SyncWriterAbst(WriterConfiguration configuration, IProgress progress) {
        this.configuration = configuration;
        this.progress = progress;
        this.bufferSize = ArchiveConstant.INSERT_PAGE_SIZE;
        this.dbType = DB.getDBType((DBRoute)this.configuration.getRoute());
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void startWrite(RecordReceiver recordReceiver) throws SQLException {
        Record record;
        ArrayList<RowRecord> writerBuffer = new ArrayList<RowRecord>(this.bufferSize);
        while ((record = recordReceiver.getFromReader()) != null && !Thread.currentThread().isInterrupted()) {
            writerBuffer.add((RowRecord)record);
            if (writerBuffer.size() < this.bufferSize) continue;
            this.doBatchInsert(writerBuffer);
            writerBuffer.clear();
        }
        if (!writerBuffer.isEmpty()) {
            this.doBatchInsert(writerBuffer);
            writerBuffer.clear();
        }
    }

    protected abstract void doBatchInsert(List<RowRecord> var1) throws SQLException;

    protected boolean existsPK(DBRoute route, String tableName, String pkField, Object pkValue) {
        String sql = "select 1 from " + tableName + " where " + pkField + "=?";
        if (MCArchive.isArchiveRoute((String)route.getRouteKey())) {
            sql = ArchiveUtil.wrapSQL(sql, true, true);
        }
        return (Boolean)DB.query((DBRoute)route, (String)sql, (Object[])new Object[]{pkValue}, rs -> rs.next());
    }

    protected void deleteDuplicate(String tableName, String pkField, List<Object> pks) {
        List<List> splitList = this.deleteSplitList(pks);
        for (List range : splitList) {
            SqlBuilder delSqlBuilder = new SqlBuilder();
            delSqlBuilder.append("/*dialect*/", new Object[0]);
            delSqlBuilder.append("/*XDB:NO_SHARDING*/", new Object[0]);
            delSqlBuilder.append("delete from ", new Object[0]).append(tableName, new Object[0]);
            delSqlBuilder.append(" where ", new Object[0]).appendIn(pkField, range);
            ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getRoute(), delSqlBuilder);
        }
    }

    protected List<List> deleteSplitList(List<Object> pks) {
        ArrayList<List> ranges = new ArrayList<List>(10);
        int pageSize = ArchiveConstant.DELETE_SPLIT_SIZE;
        if (!ArchiveServiceConfig.isArchiveSplitDelEnable() || pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }
}

