/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup.pk;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.framework.engine.ArchivePluginEngineFactory;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.transport.exchanger.RecordSender;
import kd.bos.archive.transport.record.RowRecord;

public class SyncPkForwardPluginReader
implements Reader {
    private WriterConfiguration configuration;

    public SyncPkForwardPluginReader(WriterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void startRead(RecordSender recordSender) {
        Iterator iterator = ArchivePluginEngineFactory.get().parserIterator(this.configuration.getArchivePlugin());
        try {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            while (iterator.hasNext()) {
                RowRecord rowRecord = new RowRecord(1);
                Object pkValue = iterator.next();
                if (pkValue instanceof Row) {
                    pkValue = ((Row)pkValue).get(0);
                }
                rowRecord.setPk(pkValue);
                rowRecord.setColumn(0, pkValue);
                recordSender.sendToWriter(rowRecord);
            }
        }
        catch (Error | Exception e) {
            this.close(iterator);
            throw ExceptionUtil.wrap(e);
        }
        this.close(iterator);
    }

    void close(Iterator iterator) {
        if (iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)iterator)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

