/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup.pk;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.sync.service.taskgroup.SyncWriterAbst;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

public class SyncPkForwardWriter
extends SyncWriterAbst {
    private int loop = 0;
    private long totalCount = 0L;
    private static final String queryTotalSql = "select fpendingcount from t_cbs_archi_task where fid = ? ";

    public SyncPkForwardWriter(WriterConfiguration configuration, IProgress progress) {
        super(configuration, progress);
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        if (this.configuration.getArchivePlugin() == null && this.totalCount >= (long)ArchiveConstant.EXCEED_LIMIT_SIZE) {
            return;
        }
        ArchiveName mainTN = ArchiveName.of((String)this.configuration.getMainTable());
        String mainMvTable = mainTN.getArchivePkmTable(0L);
        int size = writerBuffer.size();
        Object fromPk = writerBuffer.get(0).getPk();
        Object lastPk = writerBuffer.get(size - 1).getPk();
        List paramsList = writerBuffer.stream().map(RowRecord::getPkAndIndex).collect(Collectors.toList());
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        if (DBType.MySQL == this.dbType) {
            sql.append("replace into ").append(mainMvTable).append("(fid,findex) values(?,?)");
        } else {
            if (this.progress.isNeedDel()) {
                this.deleteDuplicate(mainMvTable, "fid", writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList()));
            }
            sql.append("insert into ").append(mainMvTable).append("(fid,findex) values(?,?)");
        }
        DB.executeBatch((DBRoute)this.configuration.getRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
            this.totalCount = (Long)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(queryTotalSql, true, true), (Object[])new Object[]{this.configuration.getTaskEntity().getId()}, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
        }
        this.progress.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_5", (String)"pk intermediate table data generation:fromPK={0}, toPK={1}, pks={2}", (Object[])new Object[]{fromPk, lastPk, size}));
        this.progress.setToPk(lastPk);
        String incrSql = "update t_cbs_archi_task set fpendingcount = fpendingcount + ? where fid =? ";
        Object[] parmas = new Object[]{size, this.configuration.getTaskEntity().getId()};
        try (TXHandle tx = TX.requiresNew((String)"incrToTalRecordAndStore");){
            DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(incrSql, true, true), (Object[])parmas);
            this.progress.store();
            this.totalCount = this.totalCount != 0L ? (this.totalCount += (long)size) : (Long)DB.query((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(queryTotalSql, true, true), (Object[])new Object[]{this.configuration.getTaskEntity().getId()}, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
        }
    }
}

