/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.service.taskgroup.split;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.transport.exchanger.RecordSender;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.xdb.tablemanager.TableName;

public class SyncCrossDataReader
implements Reader {
    private WriterConfiguration configuration;
    private ArchiveSplitTaskEntity splitTaskEntity;
    private ArchiveConfig config;
    private Object lastPk;
    private ArchiveConfig keyConfig;
    private String keyMvTable;
    private String pkField;
    private boolean isLang;
    private String columnFields;
    private int columnLength;
    private int pkidLength;
    private boolean isShardHandle;

    public SyncCrossDataReader(ArchiveSplitTaskEntity splitTaskEntity, WriterConfiguration configuration, ArchiveConfig config, ArchiveConfig keyConfig, String columnFields, Object lastPk) {
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.config = config;
        this.keyConfig = keyConfig;
        this.keyMvTable = ArchiveName.of((String)this.keyConfig.getTable()).getArchivePkmTable((long)splitTaskEntity.getSeq());
        this.lastPk = lastPk;
        this.columnFields = columnFields;
        this.pkField = config.getPrimaryKey();
        String[] fields = this.columnFields.split(",");
        this.columnLength = fields.length;
        boolean bl = this.isLang = config instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)config).isLangTableConfig();
        if (this.isLang) {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].equalsIgnoreCase("fpkid")) continue;
                this.pkidLength = i + 1;
                break;
            }
        } else {
            this.pkidLength = 1;
        }
        this.isShardHandle = this.configuration.isXdb();
    }

    @Override
    public void startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        String shardTable;
        String oriTable = this.config.getTable();
        String string = shardTable = this.isShardHandle ? TableName.of((String)oriTable).getShardingTable((long)this.splitTaskEntity.getIndex()) : oriTable;
        if (this.isShardHandle) {
            boolean isExist = false;
            try {
                isExist = TableManager.get().existTable(this.configuration.getRoute(), shardTable);
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
            if (!isExist) {
                return;
            }
        }
        Object fromPK = this.lastPk;
        do {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ArrayList<Object> paramList = new ArrayList<Object>(2);
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(ArchiveConstant.CROSS_PAGE_SIZE).append(" ");
            sql.append(this.packJoinField(this.columnFields)).append(" from ").append(this.keyMvTable).append(" A inner join ").append(shardTable).append(" B on B.").append(this.pkField).append("=A.FID ");
            if (fromPK != null) {
                sql.append(" where A.FID");
                if (this.isLang) {
                    sql.append(" >= ?");
                } else {
                    sql.append(" > ?");
                }
                paramList.add(fromPK);
            }
            sql.append(" order by A.FID").append(" asc ");
            String s = ArchiveUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"CrossDataReader", (DBRoute)this.configuration.getRoute(), (String)s, (Object[])paramList.toArray());){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(this.columnLength);
                    if (this.isLang) {
                        rowRecord.setPkId(row.get(this.pkidLength - 1));
                    }
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    rowRecord.setColumn(0, pkValue);
                    rowRecord.setIndex(this.splitTaskEntity.getIndex());
                    for (int i = 1; i < this.columnLength; ++i) {
                        rowRecord.setColumn(i, row.get(i));
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= ArchiveConstant.CROSS_PAGE_SIZE);
    }

    private String packJoinField(String fieldsString) {
        StringBuilder sql = new StringBuilder();
        String[] columnList = fieldsString.split(",");
        int n = columnList.length;
        for (int i = 0; i < n; ++i) {
            sql.append('B').append('.').append(columnList[i]);
            if (i == n - 1) continue;
            sql.append(',');
        }
        return sql.toString();
    }
}

