/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.connection;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.archive.sync.spi.connection.ConnectionType;
import kd.bos.util.StringUtils;

public class ConnectionTypeFactory {
    private static final ConcurrentHashMap<String, String> codeNamecache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, ConnectionType> connectionTypeCache = new ConcurrentHashMap();

    public static String getName(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return code;
        }
        return codeNamecache.get(code);
    }

    public static ConnectionType getConnectionType(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        return connectionTypeCache.get(code);
    }

    public static Map<String, String> getAll() {
        return codeNamecache;
    }

    static {
        ServiceLoader<ConnectionType> load = ServiceLoader.load(ConnectionType.class);
        for (ConnectionType connectionType : load) {
            codeNamecache.put(connectionType.getConnectionTypeCode(), connectionType.getConnectionTypeName());
            connectionTypeCache.put(connectionType.getConnectionTypeCode(), connectionType);
        }
    }
}

