/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.destination;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.archive.sync.spi.connection.ConnectionType;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.bundle.BosRes;
import kd.bos.extension.ExtensionFactory;
import kd.bos.util.ExceptionUtils;

public class DestinationFactory {
    private static ConcurrentHashMap<String, Destination> poolMap = new ConcurrentHashMap();
    private static ExtensionFactory<Destination> factory = ExtensionFactory.getExtensionFacotry(Destination.class);

    public static Destination getDestination(ConnectionType connectionType) {
        String key = connectionType.getConnectionTypeCode();
        return poolMap.computeIfAbsent(key, x -> {
            Destination destination = DestinationFactory.getDestinationExtension(connectionType.getConnectionTypeCode());
            return destination;
        });
    }

    private static Destination getDestinationExtension(String connectionType) {
        Destination destination = null;
        try {
            destination = (Destination)factory.getExtension(connectionType, false);
        }
        catch (Exception e) {
            ExceptionUtils.parseException((Throwable)e);
        }
        if (destination == null) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"DestinationFactory_0", (String)"[ %s ] types of target address synchronization are not supported.", (Object[])new Object[]{connectionType}));
        }
        return destination;
    }
}

