/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.destination.impl;

import java.util.Locale;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class MysqlDestinationImpl
implements Destination {
    @Override
    public String getExistTableSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT 1 FROM (");
        sql.append(" select TABLE_NAME, case when TABLE_TYPE = 'BASE TABLE' then 'U' else 'V' end TABLE_XTYPE, TABLE_SCHEMA ");
        sql.append(" from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = SCHEMA()");
        sql.append(" )AS KSQL_USERTABLES WHERE TABLE_SCHEMA = SCHEMA() ");
        sql.append("  AND (TABLE_NAME='").append(tableName.toUpperCase(Locale.ENGLISH)).append("')");
        return sql.toString();
    }

    @Override
    public String getQueryColumnsSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ordinal_position as column_id, column_name as column_name,data_type as data_type ,column_default as data_default,  ");
        sql.append(" character_maximum_length as data_length,numeric_precision as data_precision,numeric_scale as data_scale,is_nullable as nullable ");
        sql.append(" from information_schema.columns ");
        sql.append(" where  table_schema = schema() and (table_name= ").append("'").append(tableName.toUpperCase(Locale.ENGLISH)).append("') ");
        sql.append(" order by ordinal_position ");
        return sql.toString();
    }

    @Override
    public String getCreatePkIndexSql(String tableName, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(tableName.toUpperCase(Locale.ENGLISH)).append(" ADD ");
        createTablePK.append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public String decorateDataDefault(Object dataDefaultStr) {
        if (dataDefaultStr != null && dataDefaultStr.toString().length() > 0) {
            String dataDefault;
            int seq = (dataDefault = String.valueOf(dataDefaultStr)).indexOf("::");
            return dataDefault.substring(0, seq > 0 ? seq : dataDefault.length());
        }
        return null;
    }

    @Override
    public String getDialectColumnDesc(Column column) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        Object dataDefault = column.getDataDefault();
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            columnDesc.append("SMALLINT");
        } else if (dataType.equalsIgnoreCase("INT")) {
            columnDesc.append("INT");
        } else if (dataType.equalsIgnoreCase("BIGINT")) {
            columnDesc.append("BIGINT(20)");
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            columnDesc.append("CHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            columnDesc.append("CHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            columnDesc.append("VARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            columnDesc.append("VARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            columnDesc.append("LONGTEXT");
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            columnDesc.append("LONGBLOB");
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            columnDesc.append("LONGTEXT");
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            columnDesc.append("DATETIME");
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            columnDesc.append("NUMERIC (");
            columnDesc.append(dataPrecision);
            columnDesc.append(", ");
            columnDesc.append(dataScale);
            columnDesc.append(")");
        } else {
            columnDesc.append(dataType);
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        dataDefault = this.decorateDataDefault(dataDefault);
        if (dataDefault != null) {
            columnDesc.append(" DEFAULT ");
            columnDesc.append(dataDefault.toString().trim().length() == 0 ? "' '" : dataDefault);
        }
        return columnDesc.toString();
    }
}

