/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.destination.impl;

import java.util.Locale;
import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class OracleDestinationImpl
implements Destination {
    @Override
    public String getExistTableSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT 1 FROM (");
        sql.append("SELECT OBJECT_NAME TABLE_NAME,CREATED CREATE_TIME ");
        sql.append(" FROM USER_OBJECTS WHERE OBJECT_TYPE='TABLE' OR OBJECT_TYPE='VIEW' ");
        sql.append(" ) WHERE TABLE_NAME='").append(tableName.toUpperCase(Locale.ENGLISH)).append("' ");
        return sql.toString();
    }

    @Override
    public String getQueryColumnsSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select column_id as column_id, column_name as column_name,data_type as data_type ,data_default as data_default,  ");
        sql.append(" char_length as data_length,data_precision as data_precision,data_scale as data_scale,nullable as nullable ");
        sql.append(" from user_tab_columns where  table_name = ").append("'").append(tableName.toUpperCase(Locale.ENGLISH)).append("' ");
        sql.append("  order by column_id ");
        return sql.toString();
    }

    @Override
    public String getCreatePkIndexSql(String tableName, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(tableName.toUpperCase(Locale.ENGLISH)).append(" ADD CONSTRAINT ");
        String constraint_name = pkInfo.getIndexName();
        String indexName = constraint_name.equalsIgnoreCase("PRIMARY") ? "pk_" + tableName : ArchiveName.of((String)constraint_name).getArchiveIndex("", "");
        createTablePK.append(indexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public String decorateDataDefault(Object dataDefaultStr) {
        if (dataDefaultStr != null && dataDefaultStr.toString().length() > 0) {
            String dataDefault;
            int seq = (dataDefault = String.valueOf(dataDefaultStr)).indexOf("::");
            return dataDefault.substring(0, seq > 0 ? seq : dataDefault.length());
        }
        return null;
    }

    @Override
    public String getDialectColumnDesc(Column column) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        Object dataDefault = column.getDataDefault();
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            columnDesc.append("NUMBER (10)");
        } else if (dataType.equalsIgnoreCase("INT")) {
            columnDesc.append("NUMBER (10)");
        } else if (dataType.equalsIgnoreCase("BIGINT")) {
            columnDesc.append("NUMBER (19)");
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            columnDesc.append("CHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            columnDesc.append("NCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            columnDesc.append("VARCHAR2 (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            columnDesc.append("NVARCHAR2 (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            columnDesc.append("NCLOB");
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            columnDesc.append("BLOB");
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            columnDesc.append("CLOB");
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            columnDesc.append("TIMESTAMP");
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            if (dataPrecision > 0) {
                columnDesc.append("NUMERIC (");
                columnDesc.append(dataPrecision);
                columnDesc.append(", ");
                columnDesc.append(dataScale);
                columnDesc.append(")");
            } else {
                columnDesc.append("NUMERIC");
            }
        } else {
            columnDesc.append(dataType);
        }
        dataDefault = this.decorateDataDefault(dataDefault);
        if (dataDefault != null && dataDefault.toString().length() > 0) {
            if ("BIGINT".equalsIgnoreCase(dataType) || "SMALLINT".equalsIgnoreCase(dataType) || "INT".equalsIgnoreCase(dataType) || "DECIMAL".equalsIgnoreCase(dataType)) {
                columnDesc.append(" DEFAULT ");
                columnDesc.append(dataDefault);
            } else if ("CHAR".equals(dataType) || "NCHAR".equals(dataType) || "VARCHAR".equals(dataType) || "NVARCHAR".equals(dataType)) {
                columnDesc.append(" DEFAULT ");
                columnDesc.append(dataDefault.toString().trim().length() == 0 ? "' '" : dataDefault);
            }
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        return columnDesc.toString();
    }
}

