/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.sync.spi.destination.impl;

import kd.bos.archive.sync.spi.destination.Destination;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class PostgresqlDestinationImpl
implements Destination {
    @Override
    public String getExistTableSql(String tableName) {
        return "SELECT 1 FROM information_schema.tables WHERE table_name = '" + tableName.toLowerCase() + "' ";
    }

    @Override
    public String getQueryColumnsSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select s.ordinal_position as column_id, s.column_name as column_name,t.typname as data_type ,s.column_default as data_default,  ");
        sql.append(" s.character_maximum_length as data_length,s.numeric_precision as data_precision,s.numeric_scale as data_scale,s.is_nullable as nullable ");
        sql.append(" from information_schema.columns s,pg_attribute a, pg_class c, pg_type t ");
        sql.append(" where  table_schema = current_schema () and s.table_name = c.relname and s.ordinal_position = a.attnum ");
        sql.append(" and a.attrelid = c.oid and a.atttypid = t.oid and s.table_name= ").append("'").append(tableName.toLowerCase()).append("' ");
        sql.append("  order by s.ordinal_position ");
        return sql.toString();
    }

    @Override
    public String getCreatePkIndexSql(String tableName, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(tableName.toLowerCase()).append(" ADD CONSTRAINT ");
        String constraint_name = pkInfo.getIndexName();
        String indexName = constraint_name.equalsIgnoreCase("PRIMARY") ? "pk_" + tableName : ArchiveName.of((String)constraint_name).getArchiveIndex("", "");
        createTablePK.append(indexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public String decorateDataDefault(Object dataDefaultStr) {
        if (dataDefaultStr != null && dataDefaultStr.toString().length() > 0) {
            String dataDefault;
            int seq = (dataDefault = String.valueOf(dataDefaultStr)).indexOf("::");
            return dataDefault.substring(0, seq > 0 ? seq : dataDefault.length());
        }
        return null;
    }

    @Override
    public String getDialectColumnDesc(Column column) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        Object dataDefault = column.getDataDefault();
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            columnDesc.append("SMALLINT");
        } else if (dataType.equalsIgnoreCase("INT")) {
            columnDesc.append("INTEGER");
        } else if (dataType.equalsIgnoreCase("BIGINT")) {
            columnDesc.append("BIGINT");
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            columnDesc.append("CHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            columnDesc.append("CHARACTER (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            columnDesc.append("CHARACTER VARYING (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            columnDesc.append("VARCHAR (");
            columnDesc.append(dataLength);
            columnDesc.append(")");
        } else if (dataType.equalsIgnoreCase("NCLOB")) {
            columnDesc.append("TEXT");
        } else if (dataType.equalsIgnoreCase("BLOB")) {
            columnDesc.append("BYTEA");
        } else if (dataType.equalsIgnoreCase("CLOB")) {
            columnDesc.append("TEXT");
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            columnDesc.append("TIMESTAMP WITHOUT TIME ZONE");
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            columnDesc.append("NUMERIC (");
            columnDesc.append(dataPrecision);
            columnDesc.append(", ");
            columnDesc.append(dataScale);
            columnDesc.append(")");
        } else {
            columnDesc.append(dataType);
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        dataDefault = this.decorateDataDefault(dataDefault);
        if (dataDefault != null && dataDefault.toString().length() > 0) {
            if ("BIGINT".equalsIgnoreCase(dataType) || "SMALLINT".equalsIgnoreCase(dataType) || "INT".equalsIgnoreCase(dataType) || "DECIMAL".equalsIgnoreCase(dataType)) {
                columnDesc.append(" DEFAULT ");
                columnDesc.append(dataDefault);
            } else if ("CHAR".equals(dataType) || "NCHAR".equals(dataType) || "VARCHAR".equals(dataType) || "NVARCHAR".equals(dataType)) {
                columnDesc.append(" DEFAULT ");
                columnDesc.append(dataDefault.toString().trim().length() == 0 ? "' '" : dataDefault);
            }
        }
        return columnDesc.toString();
    }
}

