/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.archive.tablemanager.Handle;
import kd.bos.dlock.DLock;
import kd.bos.ksql.exception.SqlTranslateException;
import kd.bos.xdb.exception.ExceptionUtil;

public interface ArchiveLockCreateCall {
    public void call() throws SQLException, SqlTranslateException;

    public static void lockAndCall(String table, ArchiveLockCreateCall call) {
        String key = "/archive/create/" + table;
        try {
            AtomicBoolean created = new AtomicBoolean();
            while (true) {
                ArchiveLockCreateCall.lock(key, () -> {
                    call.call();
                    created.set(true);
                    return null;
                });
                if (!created.get()) {
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    public static <T> T lock(String key, Handle<T> handle) throws Exception {
        try (AutoCloseable ac = ArchiveLockCreateCall.lock(key);){
            T t = handle.handle();
            return t;
        }
    }

    public static AutoCloseable lock(String key) {
        DLock lock = DLock.createReentrant((String)key, (String)"archive-manager");
        lock.lock();
        return () -> lock.unlock();
    }
}

