/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.tablemanager.ArchiveLockCreateCall;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaFactory;
import kd.bos.archive.task.config.ArchiveIndexDefine;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.MCArchive;
import kd.bos.id.ID;
import kd.bos.ksql.TransUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class TableManagerImpl
implements TableManager,
ArchiveLogable {
    public static final TableManagerImpl instance = new TableManagerImpl();

    @Override
    public boolean existTable(DBRoute dbRoute, String tableName) throws SQLException {
        return DB.exitsTableForManager((DBRoute)dbRoute, (String)tableName);
    }

    @Override
    public String createTranMvTable(DBRoute dbRoute, String tableName, boolean isMain, long suffix, PkTypeEnum type) throws SQLException {
        ArchiveName tn = ArchiveName.of((String)tableName);
        String pkmTable = tn.getArchivePkmTable(suffix);
        ArchiveLockCreateCall.lockAndCall(pkmTable, () -> {
            if (!this.existTable(dbRoute, pkmTable)) {
                String sql = isMain ? ArchiveUtil.wrapSQL("create table " + pkmTable + "(fid " + type.getValue() + " primary key,findex bigint )", false, true) : ArchiveUtil.wrapSQL("create table " + pkmTable + "(fid " + type.getValue() + " primary key,fbillid " + type.getValue() + ",findex bigint)", false, true);
                DB.execute((DBRoute)dbRoute, (String)sql);
                if (!isMain) {
                    sql = ArchiveUtil.wrapSQL("create index ix_fbillid_" + pkmTable + " on " + pkmTable + "(fbillid)", false, true);
                    DB.execute((DBRoute)dbRoute, (String)sql);
                }
            }
        });
        return tableName;
    }

    @Override
    public String createTranTable(DBRoute dbRoute, String tableName, long suffix, String logicSuffix, boolean isUnarchive) throws SQLException {
        String likeTable = tableName;
        if (isUnarchive) {
            likeTable = likeTable + logicSuffix;
        }
        ArchiveName tn = ArchiveName.of((String)tableName);
        String tranTable = tn.getArchiveTranTable(suffix);
        String strSuffix = ArchiveName.getArchiveIndexSuffix((long)suffix);
        this.createTableLike(dbRoute, tranTable, likeTable, strSuffix, logicSuffix, false);
        return tranTable;
    }

    @Override
    public void createCrossTable(DBRoute dbRoute, DBRoute archiveRoute, String oriTable, String logicTable, String logicSuffix) throws SQLException {
        Callable<Object> call = () -> {
            this.__docreateCrossTableLike(dbRoute, archiveRoute, oriTable, logicTable, logicSuffix);
            return null;
        };
        ArchiveLockCreateCall.lockAndCall(logicTable, () -> {
            if (!this.existTable(archiveRoute, logicTable)) {
                try {
                    call.call();
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw ExceptionUtil.wrap(e);
                }
            }
        });
    }

    @Override
    public List<Column> getColumns(DBRoute dbRoute, String table) throws SQLException {
        if (!MCArchive.isArchiveRoute((String)dbRoute.getRouteKey())) {
            table = DB.getOriginalsnapTableNameIfShardingTable((String)table);
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        List<Column> columnList = meta.queryColumns(dbRoute, table);
        return columnList;
    }

    @Override
    public PkInfo getPkInfo(DBRoute dbRoute, String table) throws SQLException {
        if (!MCArchive.isArchiveRoute((String)dbRoute.getRouteKey())) {
            table = DB.getOriginalsnapTableNameIfShardingTable((String)table);
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        return meta.queryPkInfo(dbRoute, table);
    }

    @Override
    public List<IndexInfo> getIndexInfos(DBRoute dbRoute, String table) throws SQLException {
        if (!MCArchive.isArchiveRoute((String)dbRoute.getRouteKey())) {
            table = DB.getOriginalsnapTableNameIfShardingTable((String)table);
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        List<IndexInfo> indexList = meta.queryIndexInfos(dbRoute, table);
        return indexList;
    }

    @Override
    public void createPkIndex(DBRoute dbRoute, String table, PkInfo pkInfo, long fseq, String logicSuffix) throws SQLException {
        Imeta meta = MetaFactory.getMeta(dbRoute);
        String strSuffix = ArchiveName.getArchiveIndexSuffix((long)fseq);
        String createTablePK = meta.createPkIndexSql(table, pkInfo, strSuffix, logicSuffix);
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("TableManagerImpl createPkIndex route:{0},createTablePK,{1}", dbRoute.getRouteKey(), createTablePK));
        }
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createTablePK, true, true));
    }

    @Override
    public void dropPkIndex(DBRoute dbRoute, String table, String index) {
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("TableManagerImpl dropPkIndex route:{0},table:{1},index:{2}", dbRoute.getRouteKey(), table, index));
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        meta.dropPkIndex(dbRoute, table, index);
    }

    @Override
    public void dropColumn(DBRoute dbRoute, String table, String column) {
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("TableManagerImpl dropColumn route:{0},table:{1},column:{2}", dbRoute.getRouteKey(), table, column));
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        meta.dropColumn(dbRoute, table, column);
    }

    @Override
    public void addColumn(DBRoute dbRoute, String table, Column column) {
        Imeta meta = MetaFactory.getMeta(dbRoute);
        meta.addColumn(dbRoute, table, column);
    }

    @Override
    public void dropIndex(DBRoute dbRoute, String table, String index) {
        if (log.isInfoEnabled()) {
            log.info(MessageFormat.format("TableManagerImpl dropIndex route:{0},table:{1},column:{2}", dbRoute.getRouteKey(), table, index));
        }
        Imeta meta = MetaFactory.getMeta(dbRoute);
        meta.dropIndex(dbRoute, table, index);
    }

    @Override
    public void addIndex(DBRoute dbRoute, String table, IndexInfo index) throws SQLException {
        Imeta meta = MetaFactory.getMeta(dbRoute);
        meta.addIndex(dbRoute, table, index);
    }

    @Override
    public void dropTable(DBRoute route, String tableName) throws SQLException {
        if (this.existTable(route, tableName)) {
            if (log.isInfoEnabled()) {
                log.info(MessageFormat.format("TableManagerImpl dropTable route:{0},table:{1}", route.getRouteKey(), tableName));
            }
            String sql = ArchiveUtil.wrapSQL("drop table " + tableName, true, true);
            DB.execute((DBRoute)route, (String)sql);
        }
    }

    private void __docreateCrossTableLike(DBRoute dbRoute, DBRoute archiveRoute, String oriTable, String logicTable, String logicSuffix) throws SQLException {
        String snapTable = DB.getOriginalsnapTableNameIfShardingTable((String)oriTable);
        if (!this.existTable(archiveRoute, logicTable)) {
            Imeta meta = MetaFactory.getMeta(dbRoute);
            List<Column> columnList = meta.queryColumns(dbRoute, snapTable);
            String createTableSQL = meta.createTableSql(logicTable, columnList);
            DB.execute((DBRoute)archiveRoute, (String)ArchiveUtil.wrapSQL(createTableSQL, true, true));
            PkInfo pkInfo = meta.queryPkInfo(dbRoute, snapTable);
            String strSuffix = ArchiveName.getArchiveIndexSuffix((long)-1L);
            String createTablePK = meta.createPkIndexSql(logicTable, pkInfo, strSuffix, logicSuffix);
            DB.execute((DBRoute)archiveRoute, (String)ArchiveUtil.wrapSQL(createTablePK, true, true));
            List<CreateIndexSqlInfo> createIndexSqlInfoList = meta.createIndexSql(dbRoute, logicTable, snapTable, pkInfo, strSuffix, logicSuffix);
            for (CreateIndexSqlInfo indexInfo : createIndexSqlInfoList) {
                String createIndexSql = indexInfo.getCreateIndexSql();
                DB.execute((DBRoute)archiveRoute, (String)ArchiveUtil.wrapSQL(createIndexSql, true, true));
            }
            List commentColumnList = columnList.stream().filter(item -> item.getColumnComment() != null).collect(Collectors.toList());
            for (Column column : commentColumnList) {
                String alterCommentSql = meta.alterCommentSql(logicTable, column);
                alterCommentSql = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)alterCommentSql));
                DB.execute((DBRoute)archiveRoute, (String)ArchiveUtil.wrapSQL(alterCommentSql, false, true));
            }
        }
    }

    @Override
    public String interceptOriTable(String table) {
        int indexOf = table.indexOf("$");
        if (indexOf != -1) {
            return table.substring(0, indexOf);
        }
        return table;
    }

    @Override
    public List<Column> findLackedColumn(List<Column> oriColumns, List<Column> archiColumns) {
        ArrayList<Column> lackerColumn = new ArrayList<Column>();
        for (Column outer : oriColumns) {
            boolean isLacked = true;
            for (Column inner : archiColumns) {
                if (!inner.getColumnName().equalsIgnoreCase(outer.getColumnName())) continue;
                isLacked = false;
                break;
            }
            if (!isLacked) continue;
            lackerColumn.add(outer);
        }
        return lackerColumn;
    }

    @Override
    public List<Column> findSurplusColumn(List<Column> oriColumns, List<Column> archiColumns) {
        ArrayList<Column> surplusColumn = new ArrayList<Column>();
        for (Column outer : archiColumns) {
            boolean isSurplus = true;
            for (Column inner : oriColumns) {
                if (!inner.getColumnName().equalsIgnoreCase(outer.getColumnName())) continue;
                isSurplus = false;
                break;
            }
            if (!isSurplus) continue;
            surplusColumn.add(outer);
        }
        return surplusColumn;
    }

    private void createTableLike(DBRoute dbRoute, String table, String likeTable, String suffix, String logicSuffix, boolean isAll) throws SQLException {
        boolean withIfNotExists;
        if (!MCArchive.isArchiveRoute((String)dbRoute.getRouteKey())) {
            likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)likeTable);
        }
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        String snapTable = likeTable;
        Callable<Object> call = () -> {
            switch (dbType) {
                case DM: 
                case Oracle: 
                case OceanBase_Oracle: 
                case YasDB: 
                case HANA: 
                case SQLServer: {
                    if (isAll) {
                        this.__docopyStructureTable(dbRoute, table, snapTable, suffix, logicSuffix);
                        break;
                    }
                    this.__doCreateTableLike_oracle(dbRoute, table, snapTable, suffix, logicSuffix);
                    break;
                }
                case MySQL: 
                case TDSQL: 
                case TiDB: {
                    this.__doCreateTableLike(dbRoute, table, snapTable);
                    break;
                }
                case PostgreSQL: 
                case GS: 
                case GS100: 
                case GaussDB: 
                case Gauss200: 
                case Gbase: 
                case KingBase: 
                case Vastbase: {
                    this.__doCreateTableLike_pg(dbRoute, table, snapTable);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(BosRes.get((String)"bos-archive", (String)"ArchiveService_1", (String)"Replicated table structures and indexes have not been implemented: dbType={0}", (Object[])new Object[]{dbType}));
                }
            }
            return null;
        };
        boolean bl = withIfNotExists = dbType == DBType.MySQL || dbType == DBType.TDSQL || dbType == DBType.TiDB || dbType == DBType.PostgreSQL || dbType == DBType.GS || dbType == DBType.GS100 || dbType == DBType.GaussDB || dbType == DBType.Gauss200 || dbType == DBType.Gbase || dbType == DBType.KingBase || dbType == DBType.Vastbase;
        if (!this.existTable(dbRoute, table)) {
            if (withIfNotExists) {
                try {
                    call.call();
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw ExceptionUtil.wrap(e);
                }
            } else {
                ArchiveLockCreateCall.lockAndCall(table, () -> {
                    if (!this.existTable(dbRoute, table)) {
                        try {
                            call.call();
                        }
                        catch (Exception e) {
                            if (e instanceof SQLException) {
                                throw (SQLException)e;
                            }
                            throw ExceptionUtil.wrap(e);
                        }
                    }
                });
            }
        }
    }

    private void __doCreateTableLike(DBRoute dbRoute, String table, String likeTable) throws SQLException {
        String sql = "create table if not exists " + table + " like " + likeTable;
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)dbRoute, (String)sql);
    }

    private void __doCreateTableLike_pg(DBRoute dbRoute, String table, String likeTable) throws SQLException {
        String sql = "create table " + table + " (like " + likeTable + " including all)";
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)dbRoute, (String)sql);
    }

    private void __doCreateTableLike_oracle(DBRoute dbRoute, String table, String likeTable, String strSuffix, String logicSuffix) throws SQLException {
        Imeta meta = MetaFactory.getMeta(dbRoute);
        likeTable = likeTable.toUpperCase();
        if (!this.existTable(dbRoute, table)) {
            List<Column> columnList = meta.queryColumns(dbRoute, likeTable);
            String createTableSQL = meta.createTableSql(table, columnList);
            DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createTableSQL, true, true));
            PkInfo pkInfo = meta.queryPkInfo(dbRoute, likeTable);
            String createTablePK = meta.createPkIndexSql(table, pkInfo, strSuffix, logicSuffix);
            DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createTablePK, true, true));
        }
    }

    @Override
    public void createMapTable(DBRoute dbRoute, String tableName) throws SQLException {
        ArchiveName tn = ArchiveName.of((String)tableName);
        String mapTable = tn.getArchiveMapTable();
        ArchiveLockCreateCall.lockAndCall(mapTable, () -> {
            if (!this.existTable(dbRoute, mapTable)) {
                String sql = ArchiveUtil.wrapSQL("create table " + mapTable + "(fid bigint primary key,ftaskid bigint,ftable_name varchar(50),fmap_name varchar(50),fcleanstatus varchar(1))", false, true);
                DB.execute((DBRoute)dbRoute, (String)sql);
            }
        });
    }

    @Override
    public void createPkTable(DBRoute dbRoute, String tableName, PkTypeEnum type, ArchiveIndexDefine[] archiveIndexDefines) throws SQLException {
        ArchiveName tn = ArchiveName.of((String)tableName);
        String pkTable = tn.getArchivePkTable();
        ArchiveLockCreateCall.lockAndCall(pkTable, () -> {
            if (!this.existTable(dbRoute, pkTable)) {
                StringBuilder sql = new StringBuilder(256).append("create table ").append(pkTable).append("(fpk ").append(type.getValue()).append(", farchiveroute varchar(50) default ' '");
                ArrayList<String> indexSQLList = new ArrayList<String>(archiveIndexDefines == null ? 1 : archiveIndexDefines.length + 1);
                indexSQLList.add("create index ix_" + ID.genStringId().replaceAll("=", "a").replaceAll("\\+", "b").replaceAll("/", "c") + "_pkarchiveroute on " + pkTable + "(fpk,farchiveroute)");
                if (archiveIndexDefines != null && archiveIndexDefines.length > 0) {
                    for (ArchiveIndexDefine def : archiveIndexDefines) {
                        sql.append(", ").append(def.getField()).append(' ');
                        switch (def.getType()) {
                            case DATE: {
                                sql.append("datetime");
                                break;
                            }
                            case INTEGER: {
                                sql.append("int default 0");
                                break;
                            }
                            case LONG: {
                                sql.append("bigint default 0");
                                break;
                            }
                            case STRING: {
                                sql.append("varchar(255) default ' '");
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("XDB unsupported index field type: " + (Object)((Object)def.getType()));
                            }
                        }
                        StringBuilder indexSQL = new StringBuilder(64).append("create index ix_").append(ID.genStringId().replaceAll("=", "a").replaceAll("\\+", "b").replaceAll("/", "c")).append('_').append(def.getField()).append(" on ").append(pkTable).append('(').append(def.getField()).append(')');
                        indexSQLList.add(indexSQL.toString());
                    }
                }
                sql.append(')');
                DBType dbType = DB.getDBType((DBRoute)dbRoute);
                String ksql = "/*dialect*//*XDB:NO_SHARDING*/" + TransUtil.translate((String)sql.toString(), (int)dbType.getValue());
                DB.execute((DBRoute)dbRoute, (String)ksql);
                for (String otherSQL : indexSQLList) {
                    DB.execute((DBRoute)dbRoute, (String)("/*dialect*//*XDB:NO_SHARDING*/" + TransUtil.translate((String)otherSQL, (int)dbType.getValue())));
                }
            }
        });
    }

    @Override
    public void backTable(DBRoute route, String tableName, String backName) throws SQLException {
        Imeta meta = MetaFactory.getMeta(route);
        if (this.existTable(route, tableName)) {
            DBType dbType = DB.getDBType((DBRoute)route);
            switch (dbType) {
                case MySQL: 
                case TDSQL: 
                case TiDB: {
                    break;
                }
                case DM: 
                case Oracle: 
                case OceanBase_Oracle: 
                case YasDB: 
                case HANA: 
                case PostgreSQL: 
                case GS: 
                case GS100: 
                case GaussDB: 
                case Gauss200: 
                case Gbase: 
                case KingBase: 
                case Vastbase: 
                case SQLServer: {
                    PkInfo pkInfo = meta.queryPkInfo(route, tableName);
                    if (null != pkInfo && null != pkInfo.getIndexName()) {
                        meta.dropPkIndex(route, tableName, pkInfo.getIndexName());
                    }
                    List<IndexInfo> indexInfoList = meta.queryIndexInfos(route, tableName);
                    for (IndexInfo indexInfo : indexInfoList) {
                        meta.dropIndex(route, tableName, indexInfo.getIndexName());
                    }
                    break;
                }
            }
            meta.rnameTable(route, tableName, backName);
        }
    }

    @Override
    public void copyStructureTable(DBRoute route, String newTableName, String likeTableName, String suffix, String logicSuffix) throws SQLException {
        this.createTableLike(route, newTableName, likeTableName, suffix, logicSuffix, true);
    }

    private void __docopyStructureTable(DBRoute dbRoute, String newTableName, String likeTableName, String suffix, String logicSuffix) throws SQLException {
        String strSuffix = '_' + suffix;
        Imeta meta = MetaFactory.getMeta(dbRoute);
        List<Column> columnList = meta.queryColumns(dbRoute, likeTableName);
        String createTableSQL = meta.createTableSql(newTableName, columnList);
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createTableSQL, true, true));
        PkInfo pkInfo = meta.queryPkInfo(dbRoute, likeTableName);
        if (pkInfo.getIndexName() != null) {
            String createTablePK = meta.createPkIndexSql(newTableName, pkInfo, strSuffix, logicSuffix);
            DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createTablePK, true, true));
        }
        List<CreateIndexSqlInfo> createIndexSqlInfoList = meta.createIndexSql(dbRoute, newTableName, likeTableName, pkInfo, strSuffix, logicSuffix);
        for (CreateIndexSqlInfo indexInfo : createIndexSqlInfoList) {
            String createIndexSql = indexInfo.getCreateIndexSql();
            DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createIndexSql, true, true));
        }
    }
}

