/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.tablemanager.meta.OracleMetaImpl;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class DMMetaImpl
extends OracleMetaImpl {
    public static final DMMetaImpl instance = new DMMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append(" select c.column_name,c.data_type,c.data_length,c.data_precision,c.data_scale,c.nullable,c.data_default,c.column_id,co.comments ");
        sql.append(" from user_tab_columns  c left join user_col_comments co on c.table_name=co.table_name and c.column_name = co.column_name ");
        sql.append(" where c.table_name= ? order by c.column_id ");
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{table}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                Column column = new Column();
                String data_default = rs.getString("data_default");
                data_default = data_default != null ? data_default.trim() : data_default;
                String column_name = rs.getString("column_name");
                String data_type = rs.getString("data_type");
                long data_length = this.parseLongNullAsZero(rs.getString("data_length"));
                int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                boolean nullable = "Y".equals(rs.getString("nullable"));
                int column_id = rs.getInt("column_id");
                String comments = rs.getString("comments");
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(data_type);
                column.setDataLength(data_length);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setNullable(nullable);
                column.setDataDefault((Object)data_default);
                column.setColumnComment(comments);
                columnList.add(column);
            }
            return columnList;
        });
    }

    @Override
    public PkInfo queryPkInfo(DBRoute dbRoute, String table) {
        table = table.toUpperCase(Locale.ENGLISH);
        String sql = "select cu.constraint_name,cu.column_name,au.index_name from user_cons_columns cu,user_constraints au where cu.constraint_name = au.constraint_name and au.constraint_type = 'P' and au.table_name = ?";
        return (PkInfo)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{table}, rs -> {
            PkInfo pkInfo = new PkInfo();
            while (rs.next()) {
                String constraint_name = rs.getString("constraint_name");
                String column_name = rs.getString("column_name");
                String index_name = rs.getString("index_name");
                pkInfo.setIndexName(constraint_name);
                pkInfo.setAliasName(index_name);
                pkInfo.addColumn(column_name, true);
            }
            return pkInfo;
        });
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(DBRoute dbRoute, String oriTable, String likeTable, PkInfo pkInfo, String suffix, String logicSuffix) {
        String table = oriTable.toUpperCase(Locale.ENGLISH);
        likeTable = likeTable.toUpperCase(Locale.ENGLISH);
        String queryIndexSql = "SELECT DBMS_METADATA.GET_DDL('INDEX',u.index_name) FROM USER_INDEXES u WHERE u.table_name=?";
        ArrayList createIndexSqlInfoList = new ArrayList(50);
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexSql, true, true), (Object[])new Object[]{likeTable}, rs -> {
            while (rs.next()) {
                String indexNameStr;
                String[] indexNameArr;
                String oriIndexName;
                CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
                String createIndexSQL = rs.getString(1);
                if (createIndexSQL.indexOf("$$\" ON \"") != -1) continue;
                String buf = createIndexSQL.substring(0, createIndexSQL.indexOf(")") + 1);
                StringBuilder sb = new StringBuilder(buf.length());
                int p1 = buf.indexOf("INDEX");
                int p2 = buf.indexOf(" ON ");
                String indexType = buf.substring(6, p1).trim();
                if (indexType.toUpperCase(Locale.ENGLISH).contains("CLUSTER") || (oriIndexName = SQLUtil.unWrapSQLTableName((String)(indexNameArr = (indexNameStr = buf.substring(p1 + 6, p2)).split("\\."))[indexNameArr.length - 1])).equalsIgnoreCase(pkInfo.getIndexName()) || pkInfo.getAliasName() != null && oriIndexName.equalsIgnoreCase(pkInfo.getAliasName()) || ArchiveServiceConfig.isIndexStandardLimit() && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("IDX") && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("XDB_IDX_")) continue;
                sb.append(buf, 0, p1 + 6);
                String indexName = ArchiveName.of((String)oriIndexName).getArchiveIndex(suffix, logicSuffix);
                sb.append(indexName).append(" ON ").append(table.toUpperCase(Locale.ENGLISH)).append(' ');
                sb.append(buf.substring(buf.indexOf(40)));
                createIndexSqlInfo.setIndexName(oriIndexName);
                createIndexSqlInfo.setCreateIndexSql(sb.toString());
                createIndexSqlInfoList.add(createIndexSqlInfo);
            }
            return createIndexSqlInfoList;
        });
    }

    @Override
    public List<IndexInfo> queryIndexInfos(DBRoute dbRoute, String likeTable) {
        likeTable = likeTable.toUpperCase(Locale.ENGLISH);
        PkInfo pkInfo = this.queryPkInfo(dbRoute, likeTable);
        String queryIndexSql = "SELECT DBMS_METADATA.GET_DDL('INDEX',u.index_name) FROM USER_INDEXES u WHERE u.table_name=?";
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexSql, true, true), (Object[])new Object[]{likeTable.toUpperCase(Locale.ENGLISH)}, rs -> {
            ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
            while (rs.next()) {
                String[] columnArray;
                int p3;
                String indexNameStr;
                String[] indexNameArr;
                String oriIndexName;
                IndexInfo indexInfo = new IndexInfo();
                String returnCreateSQL = rs.getString(1);
                if (returnCreateSQL.indexOf("$$\" ON \"") != -1) continue;
                int p1 = returnCreateSQL.indexOf(")");
                String createIndexSQL = returnCreateSQL.substring(0, p1 + 1);
                indexInfo.setCreateIndexSql(createIndexSQL);
                int p2 = createIndexSQL.indexOf("INDEX");
                String uniqueStr = createIndexSQL.substring(6, p2).trim();
                if (uniqueStr.equals("UNIQUE")) {
                    indexInfo.setUnique(true);
                }
                if (uniqueStr.toUpperCase(Locale.ENGLISH).contains("CLUSTER") || (oriIndexName = SQLUtil.unWrapSQLTableName((String)(indexNameArr = (indexNameStr = createIndexSQL.substring(p2 + 6, p3 = createIndexSQL.indexOf(" ON "))).split("\\."))[indexNameArr.length - 1])).equalsIgnoreCase(pkInfo.getIndexName()) || pkInfo.getAliasName() != null && oriIndexName.equalsIgnoreCase(pkInfo.getAliasName()) || ArchiveServiceConfig.isIndexStandardLimit() && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("IDX") && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("XDB_IDX_")) continue;
                indexInfo.setIndexName(oriIndexName);
                int p4 = createIndexSQL.indexOf(40);
                String columnList = createIndexSQL.substring(p4 + 1, p1);
                for (String columnDesc : columnArray = columnList.replace("\"", "").split(",")) {
                    String[] column = columnDesc.trim().trim().split(" ");
                    IndexColumnString columnString = column.length > 1 ? new IndexColumnString(column[0], false) : new IndexColumnString(column[0], true);
                    indexInfo.addIndexColumn(columnString);
                }
                indexInfoList.add(indexInfo);
            }
            return indexInfoList;
        });
    }
}

