/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import kd.bos.archive.tablemanager.meta.DMMetaImpl;
import kd.bos.archive.tablemanager.meta.Imeta;
import kd.bos.archive.tablemanager.meta.MetaAbs;
import kd.bos.archive.tablemanager.meta.MsSqlMetaImpl;
import kd.bos.archive.tablemanager.meta.MysqlMetaImpl;
import kd.bos.archive.tablemanager.meta.OracleMetaImpl;
import kd.bos.archive.tablemanager.meta.PgMetaImpl;
import kd.bos.archive.tablemanager.meta.YasdbMetaImpl;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;

public class MetaFactory {
    public static Imeta getMeta(DBRoute dbRoute) {
        MetaAbs imeta = null;
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        switch (dbType) {
            case DM: {
                imeta = DMMetaImpl.instance;
                break;
            }
            case Oracle: 
            case OceanBase_Oracle: 
            case HANA: {
                imeta = OracleMetaImpl.instance;
                break;
            }
            case YasDB: {
                imeta = YasdbMetaImpl.instance;
                break;
            }
            case MySQL: 
            case TDSQL: 
            case TiDB: {
                imeta = MysqlMetaImpl.instance;
                break;
            }
            case PostgreSQL: 
            case GS: 
            case GS100: 
            case GaussDB: 
            case Gauss200: 
            case Gbase: 
            case KingBase: 
            case Vastbase: {
                imeta = PgMetaImpl.instance;
                break;
            }
            case SQLServer: {
                imeta = MsSqlMetaImpl.instance;
                break;
            }
            default: {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-archive", (String)"ArchiveService_1", (String)"Replicated table structures and indexes have not been implemented: dbType={0}", (Object[])new Object[]{dbType}));
            }
        }
        return imeta;
    }
}

