/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.tablemanager.meta.MetaAbs;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class MsSqlMetaImpl
extends MetaAbs {
    public static final MsSqlMetaImpl instance = new MsSqlMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        table = table.toLowerCase();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT A.NAME column_name,B.NAME data_type,A.MAX_LENGTH data_length, COLUMNPROPERTY(A.object_id,A.NAME,'PRECISION') data_precision, ");
        sql.append(" ISNULL(COLUMNPROPERTY(A.object_id,A.NAME,'SCALE'),0) data_scale, A.is_nullable nullable,ISNULL(E.TEXT,'') data_default, ");
        sql.append(" ISNULL(G.[VALUE],'') column_comment,A.column_id column_id ");
        sql.append(" FROM sys.columns A LEFT JOIN sys.types B ON A.user_type_id = B.user_type_id ");
        sql.append(" INNER JOIN sys.objects D ON A.object_id = D.object_id AND D.TYPE = 'U' ");
        sql.append(" LEFT JOIN syscomments E ON A.default_object_id =E.id ");
        sql.append(" LEFT JOIN sys.extended_properties G ON A.object_id = G.major_id AND A.column_id = G.minor_id ");
        sql.append(" WHERE D.NAME = ? ");
        sql.append(" ORDER BY A.object_id ,A.column_id ");
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{table}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                Column column = new Column();
                String column_name = rs.getString("column_name");
                String dataType = rs.getString("data_type");
                int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                boolean nullable = "1".equals(rs.getString("nullable"));
                int column_id = rs.getInt("column_id");
                String column_comment = rs.getString("column_comment");
                String column_default = rs.getString("data_default");
                column_default = this.decorateDataDefault(column_default);
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(dataType);
                column.setDataDefault((Object)column_default);
                column.setDataLength((long)data_precision);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setNullable(nullable);
                column.setColumnComment(column_comment);
                columnList.add(column);
            }
            return columnList;
        });
    }

    private String decorateDataDefault(Object dataDefaultStr) {
        String dataDefault;
        if (dataDefaultStr != null && (dataDefault = String.valueOf(dataDefaultStr)).length() > 0) {
            int end = dataDefault.indexOf("))");
            if (end < 0) {
                end = dataDefault.indexOf("')");
            }
            if (end > 2) {
                dataDefault = dataDefault.substring(2, end);
                return dataDefault;
            }
        }
        return null;
    }

    @Override
    public void addColumn(DBRoute dbRoute, String table, Column column) {
        StringBuilder addColumnSql = new StringBuilder(1024);
        addColumnSql.append("alter table ").append(table).append(" add ").append(this.getColumnDesc(column, true));
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(addColumnSql.toString(), true, true));
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        table = table.toLowerCase();
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("EXEC sys.sp_addextendedproperty ");
        sql.append("@name = 'MS_Description', ");
        sql.append("@value = N'").append(column.getColumnComment()).append("', ");
        sql.append("@level0type = N'schema', ");
        sql.append("@level0name = N'dbo', ");
        sql.append("@level1type = N'table', ");
        sql.append("@level1name = N'").append(table).append("', ");
        sql.append("@level2type = N'column', ");
        sql.append("@level2name = N'").append(column.getColumnName()).append("'; ");
        return sql.toString();
    }

    @Override
    public String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        columnDesc.append(dataType);
        switch (dataType) {
            case "numeric": 
            case "decimal": {
                if (dataScale != 0) {
                    columnDesc.append('(').append(dataPrecision).append(',').append(dataScale).append(')');
                    break;
                }
                if (dataPrecision == 0) break;
                columnDesc.append('(').append(dataPrecision).append(")");
                break;
            }
            case "varbinary": 
            case "varchar": 
            case "nvarchar": 
            case "nchar": 
            case "char": 
            case "binary": {
                if (dataLength == 0L) break;
                columnDesc.append('(').append(dataLength).append(')');
            }
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        if (column.getDataDefault() != null && column.getDataDefault().toString().length() > 0) {
            columnDesc.append(" DEFAULT ");
            String dataDefault = String.valueOf(column.getDataDefault());
            columnDesc.append(dataDefault.trim().length() == 0 ? "' '" : dataDefault);
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(DBRoute dbRoute, String table) {
        StringBuilder queryIndexSql = new StringBuilder();
        queryIndexSql.append("SELECT i.name AS index_name, c.name AS column_name,i.is_unique,i.is_primary_key ");
        queryIndexSql.append("FROM sys.indexes i ");
        queryIndexSql.append("INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id ");
        queryIndexSql.append("INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id ");
        queryIndexSql.append("INNER JOIN sys.tables t ON i.object_id = t.object_id ");
        queryIndexSql.append("WHERE t.name = ? AND i.is_primary_key = 1 order by i.index_id, ic.index_column_id ");
        return (PkInfo)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexSql.toString(), true, true), (Object[])new Object[]{table}, rs -> {
            PkInfo pkInfo;
            block0: {
                pkInfo = new PkInfo();
                if (!rs.next()) break block0;
                String constraint_name = rs.getString(1);
                String column_name = rs.getString(2);
                pkInfo.setIndexName(constraint_name);
                pkInfo.addColumn(column_name, true);
            }
            return pkInfo;
        });
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo, String strSuffix, String logicSuffix) {
        table = table.toLowerCase();
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ");
        String constraint_name = pkInfo.getIndexName();
        String indexName = ArchiveName.of((String)constraint_name).getArchiveIndex(strSuffix, logicSuffix);
        createTablePK.append(indexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(DBRoute dbRoute, String table, String likeTable, PkInfo pkInfo, String strSuffix, String logicSuffix) {
        List<IndexInfo> indexInfoList = this.queryIndexInfos(dbRoute, likeTable);
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfos = new ArrayList<CreateIndexSqlInfo>(indexInfoList.size());
        for (IndexInfo indexInfo : indexInfoList) {
            if (indexInfo.isPrimary()) continue;
            CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(indexInfo, table);
            createIndexSqlInfos.add(createIndex);
        }
        return createIndexSqlInfos;
    }

    private CreateIndexSqlInfo assembleCreateIndexSql(IndexInfo indexInfo, String table) {
        StringBuilder createIndexSql = new StringBuilder(256);
        String indexName = indexInfo.getIndexName();
        createIndexSql.append("CREATE  ");
        if (indexInfo.isUnique()) {
            createIndexSql.append("UNIQUE ");
        }
        createIndexSql.append("INDEX ").append(indexName).append(" ON ").append(table).append(" (");
        int n = indexInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)indexInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createIndexSql.append(",");
            }
            createIndexSql.append(column);
        }
        createIndexSql.append(")");
        CreateIndexSqlInfo createIndex = new CreateIndexSqlInfo();
        createIndex.setIndexName(indexName);
        createIndex.setCreateIndexSql(createIndexSql.toString());
        return createIndex;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(DBRoute dbRoute, String likeTable) {
        StringBuilder queryIndexSql = new StringBuilder();
        queryIndexSql.append("SELECT i.name AS index_name, c.name AS column_name,i.is_unique,i.is_primary_key ");
        queryIndexSql.append("FROM sys.indexes i ");
        queryIndexSql.append("INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id ");
        queryIndexSql.append("INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id ");
        queryIndexSql.append("INNER JOIN sys.tables t ON i.object_id = t.object_id ");
        queryIndexSql.append("WHERE t.name = ? order by i.index_id, ic.index_column_id ");
        String queryIndexStr = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)queryIndexSql.toString()));
        return (List)DB.query((DBRoute)dbRoute, (String)queryIndexStr, (Object[])new Object[]{likeTable}, rs -> {
            try {
                ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
                HashMap<String, IndexInfo> temp = new HashMap<String, IndexInfo>();
                while (rs.next()) {
                    String indexName = rs.getString(1);
                    String columnName = rs.getString(2);
                    if (temp.get(indexName) == null) {
                        IndexInfo indexInfo = new IndexInfo();
                        indexInfoList.add(indexInfo);
                        indexInfo.setIndexName(indexName);
                        int is_unique = rs.getInt(3);
                        int is_primary_key = rs.getInt(4);
                        if (1 == is_unique) {
                            indexInfo.setUnique(true);
                        } else {
                            indexInfo.setUnique(false);
                        }
                        if (1 == is_primary_key) {
                            indexInfo.setPrimary(true);
                        } else {
                            indexInfo.setPrimary(false);
                        }
                        temp.put(indexName, indexInfo);
                    }
                    ((IndexInfo)temp.get(indexName)).addColumn(columnName, true);
                }
                return indexInfoList;
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        });
    }

    @Override
    public void dropIndex(DBRoute dbRoute, String table, String index) {
        table = table.toLowerCase();
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("drop index " + index + " on  " + table, true, true));
    }

    @Override
    public void dropPkIndex(DBRoute dbRoute, String table, String index) {
        table = table.toLowerCase();
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("alter table " + table + " drop constraint " + index, true, true));
    }

    @Override
    public void addIndex(DBRoute dbRoute, String table, IndexInfo index) throws SQLException {
        table = table.toLowerCase();
        String createIndexSql = this.assembleCreateIndexSql(index, table).getCreateIndexSql();
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createIndexSql, true, true));
    }

    @Override
    public void rnameTable(DBRoute dbRoute, String tableName, String backName) throws SQLException {
        tableName = tableName.toLowerCase();
        backName = backName.toLowerCase();
        String sql = "EXEC sp_rename '" + tableName + "' , '" + backName + "';";
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql, true, true));
    }

    @Override
    public void convertDialectToKsqlDataType(Column column) {
        String dataType = column.getDataType();
        String ksqlType = column.getDataType();
        if (dataType.equalsIgnoreCase("SMALLINT") || dataType.equalsIgnoreCase("INT4")) {
            ksqlType = "SMALLINT";
        } else if (dataType.equalsIgnoreCase("INTEGER")) {
            ksqlType = "INT";
        } else if (dataType.equalsIgnoreCase("BIGINT") || dataType.equalsIgnoreCase("INT8")) {
            ksqlType = "BIGINT";
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            ksqlType = "CHAR";
        } else if (dataType.equalsIgnoreCase("NCHAR")) {
            ksqlType = "NCHAR";
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            ksqlType = "VARCHAR";
        } else if (dataType.equalsIgnoreCase("NVARCHAR")) {
            ksqlType = "NVARCHAR";
        } else if (dataType.equalsIgnoreCase("NTEXT")) {
            ksqlType = "NTEXT";
        } else if (dataType.equalsIgnoreCase("TEXT")) {
            ksqlType = "TEXT";
        } else if (dataType.equalsIgnoreCase("IMAGE")) {
            ksqlType = "IMAGE";
        } else if (dataType.equalsIgnoreCase("DATETIME") || dataType.equalsIgnoreCase("TIMESTAMP")) {
            ksqlType = "DATETIME";
        } else if (dataType.equalsIgnoreCase("NUMERIC")) {
            ksqlType = "NUMERIC";
        } else if (dataType.equalsIgnoreCase("DECIMAL")) {
            ksqlType = "DECIMAL";
        }
        column.setDataType(ksqlType);
    }
}

