/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.tablemanager.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.tablemanager.meta.IMysqlMeta;
import kd.bos.archive.tablemanager.meta.MetaAbs;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class MysqlMetaImpl
extends MetaAbs
implements IMysqlMeta {
    public static final MysqlMetaImpl instance = new MysqlMetaImpl();

    @Override
    public List<Column> queryColumns(DBRoute dbRoute, String table) {
        String sql = "select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale,is_nullable,column_default,ordinal_position,column_comment from information_schema.columns where table_schema = schema() and (upper(table_name)=?) order by ordinal_position";
        sql = ArchiveUtil.wrapSQL(sql, true, true);
        return (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{table.toUpperCase(Locale.ENGLISH)}, rs -> {
            ArrayList<Column> columnList = new ArrayList<Column>(50);
            while (rs.next()) {
                Column column = new Column();
                String column_name = rs.getString("column_name");
                String data_type = rs.getString("data_type");
                String column_comment = rs.getString("column_comment");
                long data_length = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                boolean nullable = "YES".equals(rs.getString("is_nullable"));
                int column_id = rs.getInt("ordinal_position");
                column.setColumnId(column_id);
                column.setColumnName(column_name);
                column.setDataType(data_type);
                column.setDataLength(data_length);
                column.setDataPrecision(data_precision);
                column.setDataScale(data_scale);
                column.setNullable(nullable);
                column.setColumnComment(column_comment);
                if ("bigint".equals(data_type) || "smallint".equals(data_type) || "int".equals(data_type) || "decimal".equals(data_type)) {
                    column.setDataDefault((Object)0);
                } else if ("varchar".equals(data_type)) {
                    column.setDataDefault((Object)Character.valueOf(' '));
                } else if ("char".equals(data_type)) {
                    String data_default;
                    rs.getString("column_default");
                    String dataDefault = rs.getString("column_default");
                    String string = data_default = dataDefault == null ? null : dataDefault.trim();
                    column.setDataDefault(StringUtils.isEmpty((String)data_default) ? Character.valueOf(' ') : ("'0'".equals(data_default) ? Character.valueOf('0') : data_default));
                }
                columnList.add(column);
            }
            return columnList;
        });
    }

    @Override
    public void addColumn(DBRoute dbRoute, String table, Column column) {
        StringBuilder addColumnSql = new StringBuilder(1024);
        addColumnSql.append("alter table ").append(table).append(" add column ").append(this.getColumnDesc(column, true));
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(addColumnSql.toString(), true, true));
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(table).append(" MODIFY COLUMN ");
        sql.append(this.getColumnDesc(column, false)).append(" ");
        return sql.toString();
    }

    @Override
    public String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        columnDesc.append(dataType);
        switch (dataType) {
            case "date": 
            case "datetime": 
            case "text": 
            case "longtext": {
                break;
            }
            default: {
                int dataScale = column.getDataScale();
                int dataPrecision = column.getDataPrecision();
                if (dataScale != 0) {
                    columnDesc.append("(").append(dataPrecision).append(",").append(dataScale).append(")");
                    break;
                }
                if (dataPrecision != 0) {
                    columnDesc.append("(").append(dataPrecision).append(")");
                    break;
                }
                if (dataLength == 0L) break;
                columnDesc.append("(").append(dataLength).append(")");
            }
        }
        if (!column.isNullable()) {
            columnDesc.append(" NOT NULL");
        }
        if ("bigint".equals(dataType) || "smallint".equals(dataType) || "int".equals(dataType) || "decimal".equals(dataType)) {
            columnDesc.append(" DEFAULT 0");
        } else if ("varchar".equals(dataType)) {
            columnDesc.append(" DEFAULT ' '");
        } else if ("char".equals(dataType) && dataLength == 1L) {
            columnDesc.append(" DEFAULT '").append(column.getDataDefault()).append("'");
        }
        if (column.getColumnComment() != null) {
            columnDesc.append(" COMMENT ").append("'").append(column.getColumnComment()).append("'");
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(DBRoute dbRoute, String table) {
        String sql = "select column_name from information_schema.key_column_usage where table_schema = schema() and constraint_name='PRIMARY' and table_name=?";
        return (PkInfo)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql, true, true), (Object[])new Object[]{table}, rs -> {
            PkInfo pkInfo = new PkInfo();
            while (rs.next()) {
                String column_name = rs.getString("column_name");
                pkInfo.setIndexName("PRIMARY");
                pkInfo.addColumn(column_name, true);
            }
            return pkInfo;
        });
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo, String strSuffix, String logicSuffix) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD  ");
        createTablePK.append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)pkInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(DBRoute dbRoute, String table, String likeTable, PkInfo pkInfo, String suffix, String logicSuffix) {
        List<IndexInfo> indexInfoList = this.queryIndexInfos(dbRoute, likeTable);
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfos = new ArrayList<CreateIndexSqlInfo>(indexInfoList.size());
        for (IndexInfo indexInfo : indexInfoList) {
            String indexName = indexInfo.getIndexName();
            if ("PRIMARY".equalsIgnoreCase(indexName)) continue;
            CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(indexInfo, table);
            createIndexSqlInfos.add(createIndex);
        }
        return createIndexSqlInfos;
    }

    private CreateIndexSqlInfo assembleCreateIndexSql(IndexInfo indexInfo, String table) {
        StringBuilder createIndexSql = new StringBuilder(256);
        String indexName = indexInfo.getIndexName();
        createIndexSql.append("CREATE  ");
        if ("FULLTEXT".equalsIgnoreCase(indexInfo.getIndexType())) {
            createIndexSql.append("FULLTEXT ");
        } else if (indexInfo.isUnique()) {
            createIndexSql.append("UNIQUE ");
        }
        createIndexSql.append("INDEX ").append(indexName).append(" ON ").append(table).append(" (");
        int n = indexInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = ((IndexColumnString)indexInfo.getColumnNameList().get(i)).getColumn();
            if (i > 0) {
                createIndexSql.append(",");
            }
            createIndexSql.append(column);
        }
        createIndexSql.append(")");
        CreateIndexSqlInfo createIndex = new CreateIndexSqlInfo();
        createIndex.setIndexName(indexName);
        createIndex.setCreateIndexSql(createIndexSql.toString());
        return createIndex;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(DBRoute dbRoute, String likeTable) {
        String queryIndexSql = "select index_name,column_name,non_unique,index_type  from information_schema.statistics where table_schema = schema() and table_name = ? order by index_name,seq_in_index";
        return (List)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(queryIndexSql, true, true), (Object[])new Object[]{likeTable.toUpperCase()}, rs -> {
            ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
            IndexInfo indexInfo = null;
            while (rs.next()) {
                String indexName = rs.getString(1);
                String columnName = rs.getString(2);
                if (indexInfo == null || !indexInfo.getIndexName().equals(indexName)) {
                    indexInfo = new IndexInfo();
                    indexInfoList.add(indexInfo);
                    indexInfo.setIndexName(indexName);
                    int nonUnique = rs.getInt(3);
                    String indexType = rs.getString(4);
                    indexInfo.setIndexType(indexType);
                    if (0 == nonUnique) {
                        indexInfo.setUnique(true);
                    } else {
                        indexInfo.setUnique(false);
                    }
                }
                indexInfo.addColumn(columnName, true);
            }
            return indexInfoList;
        });
    }

    @Override
    public void dropIndex(DBRoute dbRoute, String table, String index) {
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("drop index " + index + " on  " + table, true, true));
    }

    @Override
    public void dropPkIndex(DBRoute dbRoute, String table, String index) {
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("alter table " + table + " drop primary key ", true, true));
    }

    @Override
    public void addIndex(DBRoute dbRoute, String table, IndexInfo index) throws SQLException {
        CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(index, table);
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(createIndex.getCreateIndexSql(), true, true));
    }

    @Override
    public void rnameTable(DBRoute dbRoute, String tableName, String backName) throws SQLException {
        String sql = "rename table " + tableName + " to " + backName;
        DB.execute((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL(sql, true, true));
    }

    @Override
    public String getCreateTableSql(DBRoute dbRoute, String table) {
        return (String)DB.query((DBRoute)dbRoute, (String)ArchiveUtil.wrapSQL("SHOW CREATE TABLE " + table + ";", true, true), rs -> {
            if (rs.next()) {
                return rs.getString(2);
            }
            throw new KDException(BosErrorCode.bOS, new Object[]{"show create table \"" + table + "\" return null,please check table is exists!"});
        });
    }

    @Override
    public void convertDialectToKsqlDataType(Column column) {
        String dataType = column.getDataType();
        String ksqlType = column.getDataType();
        if (dataType.equalsIgnoreCase("SMALLINT")) {
            ksqlType = "SMALLINT";
        } else if (dataType.equalsIgnoreCase("INT")) {
            ksqlType = "INT";
        }
        if (dataType.equalsIgnoreCase("BIGINT")) {
            ksqlType = "BIGINT";
        } else if (dataType.equalsIgnoreCase("CHAR")) {
            ksqlType = "CHAR";
        } else if (dataType.equalsIgnoreCase("VARCHAR")) {
            ksqlType = "VARCHAR";
        } else if (dataType.equalsIgnoreCase("LONGTEXT")) {
            ksqlType = "NCLOB";
        } else if (dataType.equalsIgnoreCase("LONGBLOB")) {
            ksqlType = "BLOB";
        } else if (dataType.equalsIgnoreCase("DATETIME")) {
            ksqlType = "DATETIME";
        } else if (dataType.equalsIgnoreCase("NUMERIC")) {
            ksqlType = "DECIMAL";
        }
        column.setDataType(ksqlType);
    }
}

