/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.sync.DBUtil;
import kd.bos.archive.sync.DestinationConfigFactory;
import kd.bos.archive.sync.service.SyncDataProcessService;
import kd.bos.archive.sync.service.SyncPkInsertService;
import kd.bos.archive.sync.service.SyncStructureCheckService;
import kd.bos.archive.sync.service.SyncTempCleanService;
import kd.bos.archive.sync.spi.destination.DestinationFactory;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.config.ConfigurationFactory;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.config.WriterConfiguration;
import kd.bos.archive.task.resultnotify.ArchiveResultEnum;
import kd.bos.archive.task.resultnotify.DBArchiveResultNotifier;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultNotifyPublish;
import kd.bos.archive.task.service.StartService;
import kd.bos.archive.task.service.db.BarrierAbortService;
import kd.bos.archive.task.service.db.BarrierService;
import kd.bos.archive.task.service.db.DataCleanService;
import kd.bos.archive.task.service.db.DataMigrateService;
import kd.bos.archive.task.service.db.PkInsertService;
import kd.bos.archive.task.service.db.TbStructureCheckService;
import kd.bos.archive.task.service.db.TempCleanService;
import kd.bos.archive.task.service.elasticsearch.EsDataMigrateService;
import kd.bos.archive.task.service.elasticsearch.EsPkInsertService;
import kd.bos.archive.task.service.elasticsearch.EsTempCleanService;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.dlock.DLock;

public class TaskContainer {
    private final ArchiveService dispatcher;
    private final ArchiveTaskEntity taskEntity;
    private final DLock lock;
    private final RequestContext rc;

    public TaskContainer(ArchiveService dispatcher, ArchiveTaskEntity taskEntity, DLock lock, RequestContext rc) {
        this.dispatcher = dispatcher;
        this.taskEntity = taskEntity;
        this.lock = lock;
        this.rc = rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        BaseConfiguration configuration = null;
        try {
            configuration = ConfigurationFactory.createConfig(this.taskEntity);
            StartService startService = new StartService(this.taskEntity);
            if (this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.ARCHIVESYNC) {
                long firstIndex;
                WriterConfiguration writerConfiguration = (WriterConfiguration)configuration;
                writerConfiguration.setDestinationConfig(DestinationConfigFactory.getDestinationConfig(writerConfiguration.getConfigEntity().getRegion()));
                writerConfiguration.setDestination(DestinationFactory.getDestination(writerConfiguration.getConnectionType()));
                Connection connection = DBUtil.getConnection(writerConfiguration.getConnectionType(), writerConfiguration.getDestinationConfig().getJdbcUrl(), writerConfiguration.getDestinationConfig().getUsername(), writerConfiguration.getDestinationConfig().getPassword());
                try {
                    DBType dBType = DBUtil.getDBType(connection);
                    DBType routeType = DB.getDBType((DBRoute)writerConfiguration.getRoute());
                    writerConfiguration.setSourceDestinationSame(dBType == routeType);
                }
                finally {
                    DBUtil.closeDBResources(null, null, connection);
                }
                if (writerConfiguration.isXdb() && this.taskEntity.getIndex() <= 0 && (firstIndex = writerConfiguration.getFirstShardingIndex()) != -1L) {
                    ArchiveTaskRepository.get().updateIndex(this.taskEntity.getId(), firstIndex);
                }
                SyncStructureCheckService syncStructureCheckService = new SyncStructureCheckService(this.taskEntity, writerConfiguration);
                SyncPkInsertService syncPkInsertService = new SyncPkInsertService(this.taskEntity, writerConfiguration);
                SyncDataProcessService syncDataProcessService = new SyncDataProcessService(this.taskEntity, writerConfiguration);
                SyncTempCleanService syncTempCleanService = new SyncTempCleanService(this.taskEntity, writerConfiguration);
                startService.setNext(syncStructureCheckService);
                syncStructureCheckService.setNext(syncPkInsertService);
                syncPkInsertService.setNext(syncDataProcessService);
                syncDataProcessService.setNext(syncTempCleanService);
            } else if (ArchiveService.isLogEntity(this.taskEntity.getEntitynumber()).booleanValue() && ESConfig.getDcESServer().isEslogEnable()) {
                ESConfiguration esConfiguration = (ESConfiguration)configuration;
                EsPkInsertService esDataFilterService = new EsPkInsertService(this.taskEntity, esConfiguration);
                EsDataMigrateService esDataMigrateService = new EsDataMigrateService(this.taskEntity, esConfiguration);
                EsTempCleanService esTempCleanService = new EsTempCleanService(this.taskEntity, esConfiguration);
                startService.setNext(esDataFilterService);
                esDataFilterService.setNext(esDataMigrateService);
                esDataMigrateService.setNext(esTempCleanService);
            } else {
                DBConfiguration dbConfiguration = (DBConfiguration)configuration;
                TbStructureCheckService tbStructureCheckService = new TbStructureCheckService(this.taskEntity, dbConfiguration);
                PkInsertService pkInsertService = new PkInsertService(this.taskEntity, dbConfiguration);
                DataMigrateService dataMigrateService = new DataMigrateService(this.taskEntity, dbConfiguration);
                BarrierService barrierService = new BarrierService(this.taskEntity);
                BarrierAbortService barrierAbortService = new BarrierAbortService(this.taskEntity);
                DataCleanService dataCleanService = new DataCleanService(this.taskEntity, dbConfiguration);
                TempCleanService tempCleanService = new TempCleanService(this.taskEntity, dbConfiguration);
                if (this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.ARCHIVE || this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE) {
                    long firstIndex;
                    if (dbConfiguration.isXdb() && this.taskEntity.getIndex() <= 0 && (firstIndex = dbConfiguration.getFirstShardingIndex()) != -1L) {
                        ArchiveTaskRepository.get().updateIndex(this.taskEntity.getId(), firstIndex);
                    }
                    if (this.taskEntity.getTasknode() == ArchiveTaskNodeEnum.TASKSTART || this.taskEntity.getTasknode() == ArchiveTaskNodeEnum.TBSTRUCTCHK || this.taskEntity.getTasknode() == ArchiveTaskNodeEnum.PKINSERT || this.taskEntity.getTasknode() == ArchiveTaskNodeEnum.DATAMIGRATE) {
                        startService.setNext(tbStructureCheckService);
                        tbStructureCheckService.setNext(pkInsertService);
                        pkInsertService.setNext(dataMigrateService);
                        dataMigrateService.setNext(barrierAbortService);
                    } else {
                        startService.setNext(barrierService);
                        barrierService.setNext(dataCleanService);
                        dataCleanService.setNext(tempCleanService);
                    }
                } else if (this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.DATACLEAN) {
                    startService.setNext(pkInsertService);
                    pkInsertService.setNext(dataMigrateService);
                    dataMigrateService.setNext(tempCleanService);
                } else if (this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.DATASYNC) {
                    startService.setNext(tbStructureCheckService);
                    tbStructureCheckService.setNext(pkInsertService);
                    pkInsertService.setNext(dataMigrateService);
                    dataMigrateService.setNext(tempCleanService);
                }
            }
            startService.archive();
        }
        catch (Throwable e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ArchiveTaskHandler handler error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.rc.getAccountId() + "#" + this.taskEntity.getEntitynumber(), sw.toString());
                ArchiveUtil.logError(error, e);
                ArchiveTaskEntity curTaskEntity = ArchiveTaskRepository.get().loadTask(this.taskEntity.getId());
                if (ArchiveTaskStatusEnum.UNEXECUTED == curTaskEntity.getTaskstatus()) {
                    ArchiveTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ArchiveTaskStatusEnum.UNEXECUTED, ArchiveTaskStatusEnum.FAILED);
                } else {
                    ArchiveTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ArchiveTaskStatusEnum.EXECUTING, ArchiveTaskStatusEnum.FAILED);
                }
                ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
                if ((ArchiveTaskTypeEnum.ARCHIVE == curTaskEntity.getTasktype() || ArchiveTaskTypeEnum.UNARCHIVE == curTaskEntity.getTasktype()) && configuration instanceof DBConfiguration) {
                    String archiveRoute = configuration.getConfigEntity().getArchiveRoute() + configuration.getConfigEntity().getLogicSuffix();
                    ArchiveTaskEntity rootTaskEntity = this.taskEntity;
                    if (this.taskEntity.getRootid() != 0L && this.taskEntity.getRootid() != this.taskEntity.getId()) {
                        rootTaskEntity = ArchiveTaskRepository.get().loadTask(this.taskEntity.getRootid());
                    }
                    DBArchiveResultNotifier.fireArchiveResultNotify(ArchiveResultEnum.FAILED.name(), this.taskEntity.getEntitynumber(), null != rootTaskEntity ? rootTaskEntity.getEntitynumber() : "", this.taskEntity.getId(), this.taskEntity.getSchedulercdid(), archiveRoute, 0L);
                    ArchiveResultNotifyPublish.get().publishResultNotify(ArchiveResultEnum.FAILED.name(), this.taskEntity.getEntitynumber(), null != rootTaskEntity ? rootTaskEntity.getEntitynumber() : "", this.taskEntity.getId(), this.taskEntity.getSchedulercdid(), archiveRoute, 0L);
                }
                ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                this.dispatcher.delayScheduleRetryTask(this.taskEntity, this.rc);
            }
            catch (Throwable throwable) {
                DBArchiveManager.get().notifyReloadArchiveConfig(this.taskEntity.getEntitynumber());
                DBArchiveManager.get().notifyReloadArchiveIndexConfig(this.taskEntity.getEntitynumber());
                this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
                ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                throw throwable;
            }
            DBArchiveManager.get().notifyReloadArchiveConfig(this.taskEntity.getEntitynumber());
            DBArchiveManager.get().notifyReloadArchiveIndexConfig(this.taskEntity.getEntitynumber());
            this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        }
        DBArchiveManager.get().notifyReloadArchiveConfig(this.taskEntity.getEntitynumber());
        DBArchiveManager.get().notifyReloadArchiveIndexConfig(this.taskEntity.getEntitynumber());
        this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
    }
}

