/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.task.TaskContainer;

public class TaskContainerRunner
implements Runnable,
ArchiveLogable {
    private final TaskContainer taskContainer;
    private final ArchiveTaskEntity taskEntity;

    public TaskContainerRunner(TaskContainer taskContainer, ArchiveTaskEntity taskEntity) {
        this.taskContainer = taskContainer;
        this.taskEntity = taskEntity;
    }

    @Override
    public void run() {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        try {
            Thread.currentThread().setName("ARCHIVE-TaskContainerRunner-" + this.taskEntity.getEntitynumber());
            this.taskContainer.start();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveTaskHandler error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.taskEntity.getEntitynumber(), sw.toString());
            ArchiveUtil.logError(error, e);
            ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
    }
}

