/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.config;

import com.google.common.collect.Multimap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCascadeConfigEntity;
import kd.bos.archive.entity.ArchiveConfigEntity;
import kd.bos.archive.entity.ArchiveEntityEntity;
import kd.bos.archive.entity.ArchiveIndexConfigEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveConfigFilterTypeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.framework.plugin.ArchivePlugin;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveCascadeConfigRepository;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.archive.repository.ArchiveEntityRepository;
import kd.bos.archive.repository.ArchiveIndexConfigRepository;
import kd.bos.archive.task.config.ArchiveIndexDefine;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;

public final class DBConfiguration
extends BaseConfiguration {
    private DBRoute archiveRoute;
    private DBRoute toRoute;
    private ArchivePlugin archivePlugin;
    private List<ArchiveConfig> configs;
    private Multimap<ArchiveConfig, ArchiveConfig> multimap;
    private TreeSet<ArchiveConfig> sortKey;
    private Map<String, ArchiveConfig> reverseKeyMap;
    private ArchiveConfig mainArchiveConfig;
    private boolean isXdb;
    private ArchiveCascadeConfigEntity cascadeConfigEntity;
    private ArchiveCascadeConfigEntity parentCascadeConfigEntity;
    private List<ArchiveCascadeConfigEntity> childCascadeConfigs;
    private ArchiveIndexConfigEntity indexConfigEntity;
    private ArchiveIndexDefine[] archiveIndexDefines;
    private Date maxModifytime = null;
    private transient Semaphore splitTempCleanSemaphore = new Semaphore(1);

    public DBConfiguration(ArchiveTaskEntity taskEntity) {
        super(taskEntity);
        this.taskEntity = taskEntity;
        this.entitynumber = taskEntity.getEntitynumber();
        if (ArchiveTaskTypeEnum.UNARCHIVE == taskEntity.getTasktype()) {
            ArchiveEntityEntity entityEntity = ArchiveEntityRepository.get().loadArchiveEntity(taskEntity.getConfigid());
            this.configEntity = new ArchiveConfigEntity();
            this.configEntity.setSuffix(0);
            if (taskEntity.getParentid() != 0L) {
                this.configEntity.setEntitynumber(taskEntity.getEntitynumber());
            } else {
                this.configEntity.setEntitynumber(entityEntity.getEntitynumber());
            }
            this.configEntity.setArchiveRoute(entityEntity.getArchiveRoute());
            this.configEntity.setRouteType(ArchiveRouteType.DB);
        } else if (ArchiveTaskTypeEnum.DATASYNC == taskEntity.getTasktype()) {
            ArchiveConfigEntity parentEntity = ArchiveConfigRepository.get().loadConfig(taskEntity.getConfigid());
            this.configEntity = new ArchiveConfigEntity();
            this.configEntity.setSuffix(0);
            this.configEntity.setEntitynumber(taskEntity.getEntitynumber());
            this.configEntity.setArchiveRoute(parentEntity.getArchiveRoute());
        } else if (ArchiveTaskTypeEnum.ARCHIVE == taskEntity.getTasktype() || ArchiveTaskTypeEnum.DATACLEAN == taskEntity.getTasktype()) {
            ArchiveConfigEntity curConfigEntity = ArchiveConfigRepository.get().loadConfig(taskEntity.getConfigid());
            if (taskEntity.getParentid() != 0L) {
                this.configEntity = new ArchiveConfigEntity();
                this.configEntity.setEntitynumber(taskEntity.getEntitynumber());
                this.configEntity.setArchiveRoute(curConfigEntity.getArchiveRoute());
                this.configEntity.setLogicSuffix(curConfigEntity.getLogicSuffix());
                this.configEntity.setRouteType(curConfigEntity.getRouteType());
                this.configEntity.setMovingType(curConfigEntity.getMovingType());
            } else {
                this.configEntity = curConfigEntity;
            }
            this.configEntity.setSuffix(0);
            if (ArchiveConfigFilterTypeEnum.CUSTOM == this.configEntity.getFilterType()) {
                this.archivePlugin = this.cast2ArchivePlugin(ArchiveUtil.getCondition(this.configEntity));
                if (ArchiveTaskTypeEnum.ARCHIVE == taskEntity.getTasktype() && this.archivePlugin != null) {
                    try {
                        this.archivePlugin.callScheduleInfo(taskEntity.getEntitynumber(), taskEntity.getId(), taskEntity.getSchedulercdid(), this.configEntity.getArchiveRoute() + this.configEntity.getLogicSuffix());
                    }
                    catch (Throwable e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        String error = MessageFormat.format("ArchiveTaskHandler callScheduleInfo error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", taskEntity.getId(), taskEntity.getEntitynumber(), sw.toString());
                        ArchiveUtil.logError(error, e);
                    }
                }
            }
        }
        if (this.configEntity.getRouteType() == ArchiveRouteType.ES) {
            String error = MessageFormat.format("ArchiveTaskHandler Configuration init Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", taskEntity.getEntitynumber(), taskEntity.getId(), BosRes.get((String)"bos-archive", (String)"DBConfiguration_0", (String)"The log form ElasticSearch storage is closed, please check the MC configuration.", (Object[])new Object[0]));
            ArchiveUtil.logInfo(error);
            ArchiveLogPublish.get().publishLog(taskEntity.getId(), taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
            throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
        }
        this.configs = this.configEntity.toArchiveConfigs();
        this.rootDT = ORMConfiguration.innerGetDataEntityType((String)this.entitynumber, null);
        this.route = DBRoute.of((String)this.rootDT.getDBRouteKey());
        this.archiveRoute = ArchiveTaskTypeEnum.DATACLEAN == taskEntity.getTasktype() ? null : ("cur_database".equals(this.configEntity.getArchiveRoute()) ? this.route : DBRoute.of((String)this.configEntity.getArchiveRoute()));
        this.multimap = this.configEntity.getGroupConfigs(this.configs);
        this.sortKey = this.configEntity.getSortConfigKey(this.multimap);
        this.reverseKeyMap = this.configEntity.getReverseKeyConfigs(this.multimap);
        this.mainArchiveConfig = this.configs.get(0);
        this.mainTable = this.mainArchiveConfig.getTable();
        this.cascadeConfigEntity = ArchiveCascadeConfigRepository.get().loadCascadeConfig(this.entitynumber);
        if (this.cascadeConfigEntity != null) {
            this.childCascadeConfigs = ArchiveCascadeConfigRepository.get().loadCascadeChildConfig(this.entitynumber);
            if (!this.isCascadeConfigRoot()) {
                this.parentCascadeConfigEntity = ArchiveCascadeConfigRepository.get().loadCascadeConfig(this.cascadeConfigEntity.getParentnumber());
            }
        }
        this.indexConfigEntity = ArchiveIndexConfigRepository.get().loadIndexConfig(this.entitynumber);
        if (this.indexConfigEntity != null && this.indexConfigEntity.getIndicesProperties() != null && this.indexConfigEntity.getIndicesProperties().length > 0) {
            this.archiveIndexDefines = new ArchiveIndexDefine[this.indexConfigEntity.getIndicesProperties().length];
            int i = 0;
            for (String p : this.indexConfigEntity.getIndicesProperties()) {
                this.archiveIndexDefines[i] = ArchiveUtil.createIndexDefile(p, this.rootDT);
                ++i;
            }
        }
        if (taskEntity.getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE) {
            this.fromRoute = this.archiveRoute;
            this.toRoute = this.route;
        } else {
            this.fromRoute = this.route;
            this.toRoute = this.archiveRoute;
        }
        this.isXdb = this.isXdbEntity();
    }

    public final boolean isXdbEntity() {
        ShardingConfig mainConfig;
        return DB.isXDBEnable() && (mainConfig = XDBConfig.getShardingConfigProvider().getConfig(this.mainTable)) != null && mainConfig.isEnabled();
    }

    public final long getFirstShardingIndex() throws Exception {
        List<Long> indexList = this.getShardingIndexs();
        if (indexList.isEmpty()) {
            return -1L;
        }
        return indexList.get(0);
    }

    public final long getNextShardingIndex(long curIndex) throws Exception {
        List<Long> indexList = this.getShardingIndexs();
        if (indexList.isEmpty()) {
            return -1L;
        }
        int size = indexList.size();
        int curSize = 0;
        for (int i = 0; i < size; ++i) {
            if (indexList.get(i) != curIndex) continue;
            curSize = i;
            break;
        }
        if (curSize < size - 1) {
            return indexList.get(curSize + 1);
        }
        return -1L;
    }

    public final List<Long> getShardingIndexs() throws Exception {
        if (DB.isXDBEnable()) {
            return (List)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.getFromRoute(), (boolean)false, () -> {
                TableManager tm = XDBConfig.getTableManager();
                List<String> shardingTables = Arrays.asList(tm.getShardingTable(this.mainTable));
                ArrayList indexList = new ArrayList(1);
                shardingTables.forEach(item -> indexList.add(TableName.of((String)item).getShardingIndex()));
                Collections.sort(indexList);
                return indexList;
            });
        }
        return new ArrayList<Long>(1);
    }

    public boolean isCascadeConfigRoot() {
        return this.cascadeConfigEntity != null && this.cascadeConfigEntity.isRoot();
    }

    public DBRoute getArchiveRoute() {
        return this.archiveRoute;
    }

    public DBRoute getToRoute() {
        return this.toRoute;
    }

    public ArchivePlugin getArchivePlugin() {
        return this.archivePlugin;
    }

    public List<ArchiveConfig> getConfigs() {
        return this.configs;
    }

    public Multimap<ArchiveConfig, ArchiveConfig> getMultimap() {
        return this.multimap;
    }

    public TreeSet<ArchiveConfig> getSortKey() {
        return this.sortKey;
    }

    public Map<String, ArchiveConfig> getReverseKeyMap() {
        return this.reverseKeyMap;
    }

    public ArchiveConfig getMainArchiveConfig() {
        return this.mainArchiveConfig;
    }

    public boolean isXdb() {
        return this.isXdb;
    }

    public void setMaxModifytime(Date maxModifytime) {
        this.maxModifytime = maxModifytime;
    }

    public Date getMaxModifytime() {
        return this.maxModifytime;
    }

    public Semaphore getSplitTempCleanSemaphore() {
        return this.splitTempCleanSemaphore;
    }

    public ArchiveCascadeConfigEntity getCascadeConfigEntity() {
        return this.cascadeConfigEntity;
    }

    public ArchiveIndexDefine[] getArchiveIndexDefines() {
        return this.archiveIndexDefines;
    }

    public List<ArchiveCascadeConfigEntity> getChildCascadeConfigs() {
        return this.childCascadeConfigs;
    }

    public ArchiveCascadeConfigEntity getParentCascadeConfigEntity() {
        return this.parentCascadeConfigEntity;
    }

    public ArchiveIndexConfigEntity getIndexConfigEntity() {
        return this.indexConfigEntity;
    }

    public void setIndexConfigEntity(ArchiveIndexConfigEntity indexConfigEntity) {
        this.indexConfigEntity = indexConfigEntity;
    }
}

