/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.config;

import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveConfigRepository;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.service.elasticsearch.config.ESClient;
import kd.bos.archive.task.service.elasticsearch.config.ESConfig;
import kd.bos.archive.task.service.elasticsearch.config.ESServerUri;
import kd.bos.db.DBRoute;
import kd.bos.orm.impl.ORMConfiguration;

public class ESConfiguration
extends BaseConfiguration {
    private ESConfig dcESConfig;
    private ESClient esClient;
    private ESClient esArchiveClient;

    public ESConfiguration(ArchiveTaskEntity taskEntity) {
        super(taskEntity);
        this.taskEntity = taskEntity;
        this.entitynumber = taskEntity.getEntitynumber();
        if (ArchiveTaskTypeEnum.ARCHIVE == taskEntity.getTasktype() || ArchiveTaskTypeEnum.DATACLEAN == taskEntity.getTasktype()) {
            this.configEntity = ArchiveConfigRepository.get().loadConfig(taskEntity.getConfigid());
            this.configEntity.setSuffix(0);
        }
        this.dcESConfig = ESConfig.getDcESServer();
        ESServerUri fromES = this.dcESConfig.getEsServerUriMap().get(this.dcESConfig.getAccountNumber());
        this.esClient = new ESClient();
        this.esClient.createClient(fromES.getUriList(), fromES.getUsername(), fromES.getPassword(), true, 30000, false);
        if (ArchiveTaskTypeEnum.ARCHIVE == taskEntity.getTasktype()) {
            ESServerUri toES = this.dcESConfig.getEsServerUriMap().get(this.configEntity.getArchiveRoute());
            this.esArchiveClient = new ESClient();
            this.esArchiveClient.createClient(toES.getUriList(), toES.getUsername(), toES.getPassword(), true, 30000, false);
        }
        this.rootDT = ORMConfiguration.innerGetDataEntityType((String)this.entitynumber, null);
        this.mainTable = this.rootDT.getAlias();
        this.fromRoute = this.route = DBRoute.of((String)this.rootDT.getDBRouteKey());
    }

    public ESClient getEsClient() {
        return this.esClient;
    }

    public ESClient getEsArchiveClient() {
        return this.esArchiveClient;
    }

    public boolean isEslogEnable() {
        return null != this.dcESConfig ? this.dcESConfig.isEslogEnable() : false;
    }

    public ESConfig getDcESConfig() {
        return this.dcESConfig;
    }
}

