/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.resultnotify;

import kd.bos.archive.task.resultnotify.DBArchiveResultInfo;
import kd.bos.archive.task.resultnotify.DBArchiveResultListener;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class DBArchiveResultNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_RESULT_NOTIFY_WATCHER = "archive.result.notify.watcher";
    private static final String FIRE_ARCHIVE_RESULT_NOTIFY_LOCK_KEY = "/archive/fire_result_notify";

    public static void registerArchiveResultNotifyListener(final DBArchiveResultListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DBArchiveResultInfo ai = DBArchiveResultListener.fromKey((String)newValue);
                    DBArchiveRuntime.getArchiveConfigLoader().runWithDBAccessible(() -> {
                        try {
                            l.onReceiveResultNotify(ai);
                        }
                        catch (Throwable e) {
                            log.error(e.getMessage(), e);
                        }
                    }, new RequestContextInfo(ai.getTenantId(), ai.getAccountId()));
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DBArchiveResultNotifier.observeChange((String)ARCHIVE_RESULT_NOTIFY_WATCHER, (ConfigurationChangeListener)listener);
    }

    public static void fireArchiveResultNotify(String result, String entityName, String rootEntityName, long taskId, long schedulercdid, String archiveRoute, long count) {
        String value = DBArchiveResultListener.currentKey(result, entityName, rootEntityName, taskId, schedulercdid, archiveRoute, count);
        log.info("fireArchiveResultNotify " + entityName + " " + value);
        DBArchiveResultNotifier.fireLimit((String)FIRE_ARCHIVE_RESULT_NOTIFY_LOCK_KEY, (String)ARCHIVE_RESULT_NOTIFY_WATCHER, (String)value);
    }
}

