/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.resultnotify.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultBody;
import kd.bos.db.RequestContextInfo;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;

public class ArchiveResultNotifyPublish
implements ArchiveLogable {
    public static final ArchiveResultNotifyPublish instance = new ArchiveResultNotifyPublish();

    public static ArchiveResultNotifyPublish get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishResultNotify(String result, String entityName, String rootEntityName, long taskId, long schedulercdid, String archiveRoute, long count) {
        try {
            MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.archive.mq.ArchiveResultNotify");
            RequestContextInfo rci = RequestContextInfo.get();
            ArchiveResultBody mqBody = new ArchiveResultBody(rci.getTenantId(), rci.getAccountId(), entityName, rootEntityName, result, schedulercdid, taskId, archiveRoute, count);
            try {
                if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
                    log.info("ArchiveResultNotify ArchiveResultNotifyPublish," + mqBody.toString());
                }
                ObjectMapper objectMapper = new ObjectMapper();
                String message = objectMapper.writeValueAsString((Object)mqBody);
                pub.publish(message);
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ArchiveResultNotify ArchiveResultNotifyPublish publishOperationLog error inner, entitynumber:{0}, taskId:{1}, errorinfo:{2}", entityName, taskId, sw.toString());
                log.error(error, e);
            }
            finally {
                pub.close();
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ArchiveResultNotify ArchiveResultNotifyPublish publishOperationLog error outter, entitynumber:{0}, taskId:{1}, errorinfo:{2}", entityName, taskId, sw.toString());
            log.error(error, e);
        }
    }
}

