/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveLogable;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskStatusEnum;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.progress.MainTaskProgress;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.service.IArchiveTask;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.orm.ORM;
import kd.bos.xdb.tablemanager.PkTypeEnum;

public abstract class SplitTaskServiceAbst
implements IArchiveTask,
ArchiveLogable {
    protected ArchiveSplitTaskEntity splitTaskEntity;
    protected ArchiveTaskNodeEnum taskNodeEnum;
    public MainTaskProgress mp;
    private SplitTaskServiceAbst next;

    public SplitTaskServiceAbst getNext() {
        return this.next;
    }

    public void setNext(SplitTaskServiceAbst next) {
        this.next = next;
    }

    public SplitTaskServiceAbst(ArchiveSplitTaskEntity splitTaskEntity, ArchiveTaskNodeEnum taskNodeEnum) {
        this.splitTaskEntity = splitTaskEntity;
        this.taskNodeEnum = taskNodeEnum;
    }

    @Override
    public void archive() throws Exception {
        if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
            log.info(MessageFormat.format("ArchiveTaskHandler SplitTaskServiceAbst archive begin,entitynumber:{0}, taskId:{1}, taskNode:{2}", new Object[]{this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), this.splitTaskEntity.getTasknode()}));
        }
        this.flushTaskEntity();
        if (this.splitTaskEntity.getTasknode() == this.taskNodeEnum) {
            this.archiveInit();
            if (!this.doArchive()) {
                try {
                    if (this.getNext() != null) {
                        ArchiveSplitTaskRepository.get().setNextTaskNode(this.splitTaskEntity.getId(), this.splitTaskEntity.getTasknode(), this.getNext().taskNodeEnum);
                    } else {
                        ArchiveSplitTaskRepository.get().updateSplitTaskSuccess(this.splitTaskEntity.getId());
                    }
                    ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), this.getProgressType() + BosRes.get((String)"bos-archive", (String)"ArchiveService_0", (String)"Task Node Execution Completed", (Object[])new Object[0]), this.getProgressType());
                }
                catch (Throwable e) {
                    if (this.getNext() != null) {
                        ArchiveSplitTaskRepository.get().setNextTaskNode(this.splitTaskEntity.getId(), this.getNext().taskNodeEnum, this.splitTaskEntity.getTasknode());
                    }
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("SplitTaskServiceAbst Setting next step to <{0}> error, taskId:{1}, entitynumber:{2}, errorinfo:{3}", new Object[]{this.getNext().taskNodeEnum, this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), sw.toString()});
                    log.error(error, e);
                    ArchiveSplitTaskRepository.get().setNextSplitTaskstatus(this.splitTaskEntity.getId(), ArchiveTaskStatusEnum.EXECUTING, ArchiveTaskStatusEnum.FAILED);
                    ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, "TASKSWITCHERROR");
                }
            }
        }
        if (this.getNext() != null) {
            this.getNext().archive();
        }
        if (log.isInfoEnabled() || ArchiveServiceConfig.isEnableLog()) {
            log.info(MessageFormat.format("ArchiveTaskHandler SplitTaskServiceAbst archive end,entitynumber:{0}, taskId:{1}, taskNode:{2}", new Object[]{this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), this.splitTaskEntity.getTasknode()}));
        }
    }

    protected void flushTaskEntity() throws SQLException {
        this.splitTaskEntity = ArchiveSplitTaskRepository.get().loadSplitTask(this.splitTaskEntity.getId());
        this.mp = MainTaskProgress.of(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getProgresssign());
        this.mp.setSplit(true);
        this.mp.setProgressType(this.getProgressType());
    }

    protected abstract boolean doArchive() throws Exception;

    protected void archiveInit() throws SQLException {
    }

    protected PkTypeEnum getPkTypeEnum() {
        ISimpleProperty property = ORM.create().getDataEntityType(this.splitTaskEntity.getEntitynumber()).getPrimaryKey();
        PkTypeEnum type = null;
        type = property.getPropertyType() == String.class ? PkTypeEnum.pk_string : PkTypeEnum.pk_long;
        return type;
    }

    public String getProgressType() {
        return "SPLIT#" + (Object)((Object)this.splitTaskEntity.getTasknode()) + "#" + this.splitTaskEntity.getSeq();
    }
}

