/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db;

import java.util.List;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.ArchiveService;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.threads.ThreadPools;

public class BarrierService
extends TaskServiceAbst {
    public BarrierService(ArchiveTaskEntity taskEntity) {
        super(taskEntity, ArchiveTaskNodeEnum.CASCADEBARRIER);
    }

    @Override
    protected boolean doArchive() throws Exception {
        while (!this.isBarrierRun(this.taskEntity)) {
            Thread.sleep(51000L);
        }
        if (!this.mp.isCurStepExecuted()) {
            ArchiveSplitTaskRepository.get().setUnexecutedByBarrier(this.taskEntity.getId());
            this.mp.setCurStepExecuted(true);
            this.mp.store(false);
        }
        ThreadPools.executeOnce((String)"BarrierService#submitChangeTask", () -> {
            for (int i = 0; i < 3; ++i) {
                ArchiveService.get().submitChangeTask(this.taskEntity.getEntitynumber());
                try {
                    Thread.sleep(11000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        return false;
    }

    private boolean isBarrierRun(ArchiveTaskEntity taskEntity) {
        if (taskEntity.getBarriercount() > 0L) {
            return false;
        }
        List<ArchiveTaskEntity> barrierTaskList = ArchiveTaskRepository.get().loadBarrierTask(taskEntity.getRootid());
        if (!barrierTaskList.isEmpty()) {
            for (ArchiveTaskEntity archiveTaskEntity : barrierTaskList) {
                if (archiveTaskEntity.getBarriercount() > 0L) {
                    return false;
                }
                if (taskEntity.getParentid() != 0L || archiveTaskEntity.getId() == taskEntity.getId() || archiveTaskEntity.getTasknode() == ArchiveTaskNodeEnum.TASKEND) continue;
                return false;
            }
        }
        return true;
    }
}

