/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db;

import java.util.List;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.service.SplitTaskContainer;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.bundle.BosRes;

public abstract class DataProcessService
extends TaskServiceAbst {
    private BaseConfiguration configuration;

    public DataProcessService(ArchiveTaskEntity taskEntity, ArchiveTaskNodeEnum taskNodeEnum, BaseConfiguration configuration) {
        super(taskEntity, taskNodeEnum);
        this.configuration = configuration;
    }

    @Override
    protected boolean doArchive() throws Exception {
        List<ArchiveSplitTaskEntity> splitTaskEntities = ArchiveSplitTaskRepository.get().loadUnexecutedSplitTaskList(this.taskEntity.getId());
        if (splitTaskEntities.isEmpty()) {
            if (ArchiveSplitTaskRepository.get().countSplitTaskUnclosed(this.taskEntity.getId()) > 0L) {
                throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
            }
        } else {
            for (ArchiveSplitTaskEntity splitTaskEntity : splitTaskEntities) {
                int c = ArchiveSplitTaskRepository.get().updateSplitTaskExecuting(splitTaskEntity.getId());
                if (c <= 0) continue;
                new SplitTaskContainer(splitTaskEntity, this.configuration).start();
            }
        }
        if (ArchiveSplitTaskRepository.get().countSplitTaskUnclosed(this.taskEntity.getId()) > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
        }
        return false;
    }
}

