/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.util.DisCardUtil;
import kd.bos.util.JSONUtils;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class TbStructureCheckService
extends TaskServiceAbst {
    private final DBRoute route;
    private final DBRoute archiveRoute;
    private DBConfiguration configuration;
    private boolean isTriggeredByPlugin;

    public TbStructureCheckService(ArchiveTaskEntity taskEntity, DBConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.TBSTRUCTCHK);
        this.configuration = configuration;
        this.route = this.configuration.getRoute();
        this.archiveRoute = this.configuration.getArchiveRoute();
    }

    public TbStructureCheckService(ArchiveTaskEntity taskEntity, DBConfiguration configuration, boolean isTriggeredByPlugin) {
        super(taskEntity, ArchiveTaskNodeEnum.TBSTRUCTCHK);
        this.configuration = configuration;
        this.route = this.configuration.getRoute();
        this.archiveRoute = this.configuration.getArchiveRoute();
        this.isTriggeredByPlugin = isTriggeredByPlugin;
    }

    @Override
    public boolean doArchive() throws Exception {
        DBType dbType;
        boolean isCheckIndex = false;
        if (this.configuration.isXdb() && (dbType = DB.getDBType((DBRoute)this.route)) != DBType.MySQL) {
            isCheckIndex = false;
        }
        for (ArchiveConfig archiveConfig : this.configuration.getConfigs()) {
            String oriTable = archiveConfig.getTable();
            String logicTable = archiveConfig.getLogicTable();
            boolean isExist = TableManager.get().existTable(this.archiveRoute, logicTable);
            if (!isExist) {
                TableManager.get().createCrossTable(this.route, this.archiveRoute, oriTable, logicTable, this.configuration.getConfigEntity().getLogicSuffix());
                continue;
            }
            this.checkCloumnSame(oriTable, logicTable);
            if (!isCheckIndex) continue;
            this.checkIndexSame(oriTable, logicTable);
        }
        if (!this.isTriggeredByPlugin) {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"TbStructureCheckService_0", (String)"Structural Migration Complete", (Object[])new Object[0]));
            this.mp.setToPk(null);
            this.mp.store();
        }
        return false;
    }

    private void checkCloumnSame(String oriTable, String logicTable) throws SQLException {
        List<Column> surplusColumn;
        List<Column> oriColumns = TableManager.get().getColumns(this.route, oriTable);
        List<Column> archiColumns = TableManager.get().getColumns(this.archiveRoute, logicTable);
        List<Column> lackerColumn = TableManager.get().findLackedColumn(oriColumns, archiColumns);
        if (lackerColumn.size() > 0) {
            for (Column column : lackerColumn) {
                TableManager.get().addColumn(this.archiveRoute, logicTable, column);
            }
        }
        if ((surplusColumn = TableManager.get().findSurplusColumn(oriColumns, archiColumns)).size() > 0 && log.isInfoEnabled()) {
            try {
                log.warn(MessageFormat.format("TbStructureCheckService checkCloumnSame archiveRoute:{0},oriTable,{1},surplusColumn:{2}", this.archiveRoute.getRouteKey(), oriTable, JSONUtils.toString(surplusColumn)));
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
    }

    private void checkIndexSame(String oriTable, String logicTable) throws SQLException {
        PkInfo oriPkInfo = TableManager.get().getPkInfo(this.route, oriTable);
        PkInfo archiPkInfo = TableManager.get().getPkInfo(this.archiveRoute, logicTable);
        if (log.isInfoEnabled()) {
            try {
                log.info(MessageFormat.format("TbStructureCheckService checkIndexSame route:{0},oriTable,{1},oriPkInfo:{2}", this.route.getRouteKey(), oriTable, JSONUtils.toString((Object)oriPkInfo)));
                log.info(MessageFormat.format("TbStructureCheckService checkIndexSame archiveRoute:{0},oriTable,{1},archiPkInfo:{2}", this.archiveRoute.getRouteKey(), logicTable, JSONUtils.toString((Object)archiPkInfo)));
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
        boolean isPkModify = false;
        if (!oriPkInfo.getIndexName().equalsIgnoreCase(archiPkInfo.getIndexName())) {
            isPkModify = true;
        }
        if (!isPkModify) {
            int archiSize;
            List oriPkColumnList = oriPkInfo.getColumnNameList();
            List archiPkColumnList = archiPkInfo.getColumnNameList();
            int oirSize = null != oriPkColumnList ? oriPkColumnList.size() : 0;
            int n = archiSize = null != archiPkColumnList ? archiPkColumnList.size() : 0;
            if (oirSize != archiSize) {
                isPkModify = true;
            }
            if (!isPkModify && null != oriPkColumnList && null != archiPkColumnList) {
                int n2 = oirSize;
                for (int i = 0; i < n2; ++i) {
                    IndexColumnString outerColumn = (IndexColumnString)oriPkColumnList.get(i);
                    IndexColumnString innerColumn = (IndexColumnString)archiPkColumnList.get(i);
                    if (outerColumn.isAsc() ^ innerColumn.isAsc()) {
                        isPkModify = true;
                        break;
                    }
                    if (outerColumn.getColumn().equalsIgnoreCase(innerColumn.getColumn())) continue;
                    isPkModify = true;
                    break;
                }
            }
        }
        if (isPkModify) {
            if (null != archiPkInfo.getIndexName()) {
                TableManager.get().dropPkIndex(this.archiveRoute, logicTable, archiPkInfo.getIndexName());
            }
            TableManager.get().createPkIndex(this.archiveRoute, logicTable, oriPkInfo, -1L, this.configuration.getConfigEntity().getLogicSuffix());
        }
        List<IndexInfo> oriIndexs = TableManager.get().getIndexInfos(this.route, oriTable);
        List<IndexInfo> archiIndexs = TableManager.get().getIndexInfos(this.archiveRoute, logicTable);
        if (log.isInfoEnabled()) {
            try {
                log.info(MessageFormat.format("TbStructureCheckService checkIndexSame route:{0},oriTable,{1},oriIndexs:{2}", this.route.getRouteKey(), oriTable, JSONUtils.toString(oriIndexs)));
                log.info(MessageFormat.format("TbStructureCheckService checkIndexSame archiveRoute:{0},oriTable,{1},archiIndexs:{2}", this.archiveRoute.getRouteKey(), logicTable, JSONUtils.toString(archiIndexs)));
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
        ArrayList<IndexInfo> modifyIndexs = new ArrayList<IndexInfo>(3);
        List<IndexInfo> delIndexs = this.findDelIndex(oriIndexs, archiIndexs, modifyIndexs);
        this.findLackerIndex(oriIndexs, archiIndexs, modifyIndexs);
        if (delIndexs.size() > 0) {
            for (IndexInfo indexInfo : delIndexs) {
                if (indexInfo.getIndexName().equalsIgnoreCase(oriPkInfo.getIndexName())) continue;
                TableManager.get().dropIndex(this.archiveRoute, logicTable, indexInfo.getIndexName());
            }
        }
        if (modifyIndexs.size() > 0) {
            for (IndexInfo indexInfo : modifyIndexs) {
                if (indexInfo.getIndexName().equalsIgnoreCase(oriPkInfo.getIndexName())) continue;
                TableManager.get().addIndex(this.archiveRoute, logicTable, indexInfo);
            }
        }
    }

    private List<IndexInfo> findDelIndex(List<IndexInfo> oriIndexs, List<IndexInfo> archiIndexs, List<IndexInfo> modifyIndex) {
        ArrayList<IndexInfo> delIndex = new ArrayList<IndexInfo>();
        for (IndexInfo outer : archiIndexs) {
            boolean isSurplus = true;
            boolean idModify = false;
            block1: for (IndexInfo inner : oriIndexs) {
                if (!inner.getIndexName().equalsIgnoreCase(outer.getIndexName())) continue;
                isSurplus = false;
                if (outer.isUnique() ^ inner.isUnique()) {
                    idModify = true;
                    modifyIndex.add(inner);
                    break;
                }
                List outerColumnList = outer.getColumnNameList();
                List innerColumnList = inner.getColumnNameList();
                if (outerColumnList.size() != innerColumnList.size()) {
                    idModify = true;
                    modifyIndex.add(inner);
                    break;
                }
                int n = outerColumnList.size();
                for (int i = 0; i < n; ++i) {
                    IndexColumnString outerColumn = (IndexColumnString)outerColumnList.get(i);
                    IndexColumnString innerColumn = (IndexColumnString)innerColumnList.get(i);
                    if (outerColumn.isAsc() ^ innerColumn.isAsc()) {
                        idModify = true;
                        modifyIndex.add(inner);
                        break block1;
                    }
                    if (outerColumn.getColumn().equalsIgnoreCase(innerColumn.getColumn())) continue;
                    idModify = true;
                    modifyIndex.add(inner);
                    break block1;
                }
            }
            if (idModify) {
                delIndex.add(outer);
            }
            if (!isSurplus) continue;
            delIndex.add(outer);
        }
        return delIndex;
    }

    private List<IndexInfo> findLackerIndex(List<IndexInfo> oriIndexs, List<IndexInfo> archiIndexs, List<IndexInfo> modifyIndexs) {
        for (IndexInfo outer : oriIndexs) {
            boolean isLacked = true;
            for (IndexInfo inner : archiIndexs) {
                if (!inner.getIndexName().equalsIgnoreCase(outer.getIndexName())) continue;
                isLacked = false;
                break;
            }
            if (!isLacked) continue;
            modifyIndexs.add(outer);
        }
        return modifyIndexs;
    }
}

