/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.db;

import java.text.MessageFormat;
import java.util.Date;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveCrossInfoEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveCrossInfoRepository;
import kd.bos.archive.repository.ArchiveTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.resultnotify.ArchiveResultEnum;
import kd.bos.archive.task.resultnotify.DBArchiveResultNotifier;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultNotifyPublish;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveName;
import kd.bos.id.ID;

public class TempCleanService
extends TaskServiceAbst {
    private DBConfiguration configuration;

    public TempCleanService(ArchiveTaskEntity taskEntity, DBConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.TEMPCLEAN);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler TempCleanService doArchive begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        long cnt = this.taskEntity.getTotalcount();
        String mainMvTable = ArchiveName.of((String)this.configuration.getMainTable()).getArchivePkmTable((long)this.configuration.getConfigEntity().getSuffix());
        boolean isBack = false;
        StringBuilder sql = new StringBuilder();
        if (this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE || this.taskEntity.getTasktype() == ArchiveTaskTypeEnum.ARCHIVE) {
            ArchiveName tn = ArchiveName.of((String)this.configuration.getMainTable());
            String tableNameMapTable = tn.getArchiveMapTable();
            boolean isExist = TableManager.get().existTable(this.configuration.getFromRoute(), tableNameMapTable);
            if (!isExist) {
                TableManager.get().createMapTable(this.configuration.getFromRoute(), this.configuration.getMainTable());
            }
            sql.append("insert into ").append(tableNameMapTable);
            sql.append("(fid ,ftaskid,ftable_name,fmap_name,fcleanstatus)").append(" values (?,?,?,?,?)");
            isBack = true;
        }
        String archiveRoute = this.configuration.getConfigEntity().getArchiveRoute() + this.configuration.getConfigEntity().getLogicSuffix();
        if (ArchiveServiceConfig.isEnableTrantbBack() && isBack && cnt > 0L) {
            String mapName = "archi_" + ID.longTo36Radix((long)ID.genLongId()).toLowerCase();
            TableManager.get().backTable(this.configuration.getFromRoute(), mainMvTable, mapName);
            DB.execute((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{ID.genLongId(), this.taskEntity.getId(), mainMvTable, mapName, Character.valueOf('0')});
        } else {
            TableManager.get().dropTable(this.configuration.getFromRoute(), mainMvTable);
        }
        if (isBack && cnt > 0L) {
            ArchiveCrossInfoEntity crossInfoEntity = new ArchiveCrossInfoEntity();
            crossInfoEntity.setUpdatetime(new Date());
            crossInfoEntity.setCreatetime(new Date());
            crossInfoEntity.setTaskid(this.taskEntity.getId());
            crossInfoEntity.setTasktype(this.taskEntity.getTasktype());
            crossInfoEntity.setEntitynumber(this.taskEntity.getEntitynumber());
            crossInfoEntity.setScheduleid(this.taskEntity.getScheduleid());
            crossInfoEntity.setBatchnum(this.taskEntity.getBatchnum());
            crossInfoEntity.setConfigid(this.taskEntity.getConfigid());
            crossInfoEntity.setTotalcount(this.taskEntity.getTotalcount());
            crossInfoEntity.setDatabaseType(this.configuration.getConfigEntity().getRouteType());
            crossInfoEntity.setArchiveRoute(archiveRoute);
            crossInfoEntity.setReversestatus("0");
            crossInfoEntity.setCleanstatus("0");
            ArchiveCrossInfoRepository.get().insertCrossInfo(crossInfoEntity);
        }
        if ((ArchiveTaskTypeEnum.ARCHIVE == this.taskEntity.getTasktype() || ArchiveTaskTypeEnum.UNARCHIVE == this.taskEntity.getTasktype()) && this.configuration instanceof DBConfiguration) {
            if (ArchiveTaskTypeEnum.UNARCHIVE == this.taskEntity.getTasktype()) {
                sql.setLength(0);
                sql.append("delete from t_cbs_archi_reverse_mvrcd where ftaskid = ?");
                DB.execute((DBRoute)DBRoute.base, (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.taskEntity.getId()});
            }
            ArchiveTaskEntity rootTaskEntity = this.taskEntity;
            if (this.taskEntity.getRootid() != 0L && this.taskEntity.getRootid() != this.taskEntity.getId()) {
                rootTaskEntity = ArchiveTaskRepository.get().loadTask(this.taskEntity.getRootid());
            }
            DBArchiveResultNotifier.fireArchiveResultNotify(ArchiveResultEnum.SUCCESS.name(), this.taskEntity.getEntitynumber(), null != rootTaskEntity ? rootTaskEntity.getEntitynumber() : "", this.taskEntity.getId(), this.taskEntity.getSchedulercdid(), archiveRoute, this.taskEntity.getTotalcount());
            ArchiveResultNotifyPublish.get().publishResultNotify(ArchiveResultEnum.SUCCESS.name(), this.taskEntity.getEntitynumber(), null != rootTaskEntity ? rootTaskEntity.getEntitynumber() : "", this.taskEntity.getId(), this.taskEntity.getSchedulercdid(), archiveRoute, this.taskEntity.getTotalcount());
        }
        if (this.configuration.getArchivePlugin() == null && this.configuration.getTaskEntity().getParentid() == 0L && (ArchiveTaskTypeEnum.ARCHIVE == this.configuration.getTaskEntity().getTasktype() || ArchiveTaskTypeEnum.DATACLEAN == this.configuration.getTaskEntity().getTasktype())) {
            long nextIndex;
            if (cnt >= (long)ArchiveConstant.EXCEED_LIMIT_SIZE) {
                if (ArchiveServiceConfig.isEnableRelay() || this.configuration.isXdb()) {
                    ArchiveTaskRepository.get().insertTaskByCopy(this.configuration.getTaskEntity());
                }
            } else if (this.configuration.isXdb() && (nextIndex = this.configuration.getNextShardingIndex(this.taskEntity.getIndex())) != -1L) {
                ArchiveTaskRepository.get().insertNextIndexTaskByCopy(this.configuration.getTaskEntity(), nextIndex);
            }
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler TempCleanService doArchive end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }
}

