/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.service.config.ArchiveServiceConfig;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.archive.task.service.elasticsearch.split.SplitEsCrossMoveService;
import kd.bos.archive.task.service.elasticsearch.split.SplitEsDataCleanService;
import kd.bos.archive.task.service.elasticsearch.split.SplitEsStructureCheckService;
import kd.bos.bundle.BosRes;

public class EsDataMigrateService
extends TaskServiceAbst {
    private BaseConfiguration configuration;

    public EsDataMigrateService(ArchiveTaskEntity taskEntity, BaseConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.DATAMIGRATE);
        this.configuration = configuration;
    }

    @Override
    protected boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsDataMigrateService doArchive begin,entitynumber:{0}, taskId:{1}, tasknode:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskNodeEnum.getKey()));
        if (ArchiveServiceConfig.isEnableParallel()) {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_0", (String)"Migrate Data in Parallel", (Object[])new Object[0]));
        } else {
            this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_1", (String)"Serial Migration of Data", (Object[])new Object[0]));
        }
        this.mp.store();
        List<ArchiveSplitTaskEntity> splitTaskEntities = ArchiveSplitTaskRepository.get().loadUnexecutedSplitTaskList(this.taskEntity.getId());
        if (splitTaskEntities.isEmpty()) {
            if (ArchiveSplitTaskRepository.get().countSplitTaskUnclosed(this.taskEntity.getId()) > 0L) {
                throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
            }
            ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsDataMigrateService doArchive end,entitynumber:{0}, taskId:{1}, subTaskCount:{2}, tasknode:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), splitTaskEntities.size(), this.taskNodeEnum.getKey()));
        } else {
            for (ArchiveSplitTaskEntity splitTaskEntity : splitTaskEntities) {
                int c = ArchiveSplitTaskRepository.get().updateSplitTaskExecuting(splitTaskEntity.getId());
                if (c <= 0) continue;
                if (this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.DATACLEAN) {
                    SplitEsDataCleanService splitEsDataCleanService = new SplitEsDataCleanService(splitTaskEntity, (ESConfiguration)this.configuration);
                    splitEsDataCleanService.archive();
                    continue;
                }
                SplitEsStructureCheckService splitEsStructureCheckService = new SplitEsStructureCheckService(splitTaskEntity, (ESConfiguration)this.configuration);
                SplitEsCrossMoveService splitEsCrossMoveService = new SplitEsCrossMoveService(splitTaskEntity, (ESConfiguration)this.configuration);
                SplitEsDataCleanService splitEsDataCleanService = new SplitEsDataCleanService(splitTaskEntity, (ESConfiguration)this.configuration);
                splitEsStructureCheckService.setNext(splitEsCrossMoveService);
                splitEsCrossMoveService.setNext(splitEsDataCleanService);
                splitEsStructureCheckService.archive();
            }
        }
        if (ArchiveSplitTaskRepository.get().countSplitTaskUnclosed(this.taskEntity.getId()) > 0L) {
            throw new RuntimeException(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_2", (String)"There are unfinished migration subtasks.", (Object[])new Object[0]));
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"MoveServiceAbst_3", (String)"{0} Migration Completed", (Object[])new Object[]{this.taskNodeEnum.getValue()}));
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsDataMigrateService doArchive end,entitynumber:{0}, taskId:{1}, tasknode:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskNodeEnum.getKey()));
        return false;
    }
}

