/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.repository.ArchiveSplitTaskRepository;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.TaskServiceAbst;
import kd.bos.archive.task.service.db.split.entity.SplitInfo;
import kd.bos.archive.task.service.elasticsearch.IndexNameUtil;
import kd.bos.archive.task.service.elasticsearch.LogEntityQFilterMatch;
import kd.bos.archive.task.service.elasticsearch.LogEntityQFilterUtil;
import kd.bos.bundle.BosRes;
import kd.bos.orm.query.QFilter;

public class EsPkInsertService
extends TaskServiceAbst {
    private ESConfiguration configuration;
    private QFilter conditionQFilter;

    public EsPkInsertService(ArchiveTaskEntity taskEntity, ESConfiguration configuration) {
        super(taskEntity, ArchiveTaskNodeEnum.PKINSERT);
        this.configuration = configuration;
        this.conditionQFilter = ArchiveUtil.parse2QFilter(configuration.getConfigEntity());
    }

    @Override
    public boolean doArchive() throws Exception {
        ESConfiguration esConfiguration = this.configuration;
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler EsDataFilterService doArchive begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_4", (String)"Perform data filtering", (Object[])new Object[0]));
        this.mp.store();
        if (!LogEntityQFilterUtil.verify(this.conditionQFilter)) {
            String error = MessageFormat.format("ArchiveTaskHandler EsDataFilterService doArchive Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), "qfilter config error");
            ArchiveUtil.logInfo(error);
            ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
            throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
        }
        LogEntityQFilterMatch qFilterMatch = new LogEntityQFilterMatch(this.conditionQFilter);
        String prefix = IndexNameUtil.getTableIndexPrefix(esConfiguration, false);
        String indexPattern = prefix + '*';
        JestResult jestResult = esConfiguration.getEsClient().catIndices(indexPattern);
        if (!jestResult.isSucceeded()) {
            String error = MessageFormat.format("ArchiveTaskHandler EsDataFilterService doArchive Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), jestResult.getErrorMessage());
            ArchiveUtil.logInfo(error);
            ArchiveLogPublish.get().publishLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
            throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
        }
        JsonArray jsonArray = jestResult.getJsonObject().get("result").getAsJsonArray();
        ArrayList<SplitInfo> splitList = new ArrayList<SplitInfo>(jsonArray.size());
        for (JsonElement element : jsonArray) {
            JsonObject obj = element.getAsJsonObject();
            String indexName = obj.get("index").getAsString();
            if (!indexName.startsWith(prefix) || indexName.length() != prefix.length() + 8) continue;
            String indexDate = indexName.substring(prefix.length());
            long count = obj.get("docs.count").getAsBigInteger().longValue();
            if (!qFilterMatch.isMatch(indexDate)) continue;
            SplitInfo splitInfo = new SplitInfo();
            splitList.add(splitInfo);
            splitInfo.setIndex(Long.parseLong(indexDate));
            splitInfo.setPageSize(count);
        }
        if (splitList.size() > 0) {
            ArchiveSplitTaskRepository.get().deleteSplitTask(this.taskEntity.getId());
            ArchiveTaskNodeEnum taskNodeEnum = this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.DATACLEAN ? ArchiveTaskNodeEnum.DATACLEAN : ArchiveTaskNodeEnum.TBSTRUCTCHK;
            ArchiveSplitTaskRepository.get().insertSplitTask(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), taskNodeEnum, splitList);
        }
        this.mp.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_3", (String)"Data filter complete", (Object[])new Object[0]));
        this.mp.setToPk(null);
        this.mp.store();
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler PkInsertService doArchive  end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        return false;
    }
}

