/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.util.DateUtil;

public class LogEntityQFilterMatch {
    private NodeFilter head;
    private NodeFilter tail;
    private boolean hasTail = false;

    public LogEntityQFilterMatch(QFilter qfilter) throws ParseException {
        String headCp = qfilter.getCP();
        List nestList = qfilter.getNests(true);
        Date firstValue = DateUtil.getDateFormat((String)"yyyyMMdd").parse(DateUtil.getDateFormat((String)"yyyyMMdd").format((Date)qfilter.getValue()));
        if (headCp.equals("=")) {
            this.head = new NodeFilter(headCp, firstValue);
        } else if (headCp.equals(">") || headCp.equals(">=")) {
            this.tail = new NodeFilter(headCp, firstValue);
            Date nextValue = DateUtil.getDateFormat((String)"yyyyMMdd").parse(DateUtil.getDateFormat((String)"yyyyMMdd").format((Date)((QFilter.QFilterNest)nestList.get(0)).getFilter().getValue()));
            this.head = new NodeFilter(((QFilter.QFilterNest)nestList.get(0)).getFilter().getCP(), nextValue);
            this.hasTail = true;
        } else if (headCp.equals("<") || headCp.equals("<=")) {
            this.head = new NodeFilter(headCp, firstValue);
            if (nestList.size() == 1) {
                Date nextValue = DateUtil.getDateFormat((String)"yyyyMMdd").parse(DateUtil.getDateFormat((String)"yyyyMMdd").format((Date)((QFilter.QFilterNest)nestList.get(0)).getFilter().getValue()));
                this.tail = new NodeFilter(((QFilter.QFilterNest)nestList.get(0)).getFilter().getCP(), nextValue);
                this.hasTail = true;
            }
        }
    }

    public NodeFilter getHead() {
        return this.head;
    }

    public NodeFilter getTail() {
        return this.tail;
    }

    private boolean isHasTail() {
        return this.hasTail;
    }

    public boolean isMatch(String indexSuff) throws ParseException {
        Date indexTime = DateUtil.getDateFormat((String)"yyyyMMdd").parse(indexSuff);
        if (this.head.cp.equals("=")) {
            if (!indexTime.equals(this.head.value)) {
                return false;
            }
        } else if (this.head.cp.equals("<")) {
            if (!indexTime.before(this.head.value)) {
                return false;
            }
            if (this.hasTail && (this.tail.cp.equals(">") ? !indexTime.after(this.tail.value) : this.tail.cp.equals(">=") && !indexTime.after(this.tail.value) && !indexTime.equals(this.tail.value))) {
                return false;
            }
        } else if (this.head.cp.equals("<=")) {
            if (!indexTime.before(this.head.value) && !indexTime.equals(this.head.value)) {
                return false;
            }
            if (this.hasTail && (this.tail.cp.equals(">") ? !indexTime.after(this.tail.value) : this.tail.cp.equals(">=") && !indexTime.after(this.tail.value) && !indexTime.equals(this.tail.value))) {
                return false;
            }
        }
        return true;
    }

    public static class NodeFilter {
        String cp;
        Date value;

        public NodeFilter(String cp, Date value) {
            this.cp = cp;
            this.value = value;
        }
    }
}

