/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.archive.task.service.elasticsearch.config.ESServerUri;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.MCArchive;
import kd.bos.encrypt.Encrypters;

public class ESConfig {
    private boolean isEslogEnable;
    private String accountNumber;
    private Map<String, ESServerUri> esServerUriMap;

    private ESConfig() {
    }

    private ESConfig(boolean isEslogEnable, String accountNumber, Map<String, ESServerUri> esServerUriMap) {
        this.isEslogEnable = isEslogEnable;
        this.accountNumber = accountNumber;
        this.esServerUriMap = esServerUriMap;
    }

    public boolean isEslogEnable() {
        return this.isEslogEnable ? null != this.esServerUriMap.get(this.accountNumber) : false;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public Map<String, ESServerUri> getEsServerUriMap() {
        return this.esServerUriMap;
    }

    public static ESConfig getDcESServer() {
        RequestContextInfo rc;
        try {
            rc = RequestContextInfo.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map dc = MCArchive.getDCInfo((String)rc.getAccountId(), (String)rc.getTenantId());
        HashMap<String, ESServerUri> esServerUriMap = new HashMap<String, ESServerUri>();
        boolean isEslog = false;
        String accountNumber = "";
        if (dc != null) {
            Object esLogArchiveInfo;
            LinkedHashMap esCluster;
            Object isEslogEnable = dc.get("isEslogEnable");
            if (isEslogEnable != null) {
                isEslog = Boolean.parseBoolean(isEslogEnable.toString());
            }
            accountNumber = ((String)dc.get("datacenternumber")).trim();
            Object esloginfo = dc.get("esCluster");
            if (esloginfo != null && !(esCluster = (LinkedHashMap)esloginfo).isEmpty()) {
                esServerUriMap.put(accountNumber, ESConfig.getESClusterUri(esCluster));
            }
            if ((esLogArchiveInfo = dc.get("esArchiveCluster")) != null) {
                ArrayList archiveKeys = (ArrayList)esLogArchiveInfo;
                for (Object o : archiveKeys) {
                    LinkedHashMap esCluster2;
                    LinkedHashMap archiveKey = (LinkedHashMap)o;
                    String key = (String)archiveKey.get("key");
                    Object archiEsloginfo = archiveKey.get("esCluster");
                    if (archiEsloginfo == null || (esCluster2 = (LinkedHashMap)archiEsloginfo).isEmpty()) continue;
                    esServerUriMap.put(key, ESConfig.getESClusterUri(esCluster2));
                }
            }
        }
        return new ESConfig(isEslog, accountNumber, esServerUriMap);
    }

    private static ESServerUri getESClusterUri(LinkedHashMap esCluster) {
        ESServerUri serverUri = new ESServerUri();
        String userName = (String)esCluster.get("username");
        String passwd = Encrypters.decode((String)((String)esCluster.get("passwd")));
        ArrayList urls = (ArrayList)esCluster.get("urls");
        for (Object o : urls) {
            LinkedHashMap key = (LinkedHashMap)o;
            String host = (String)key.get("ip");
            String port = String.valueOf(key.get("port"));
            serverUri.getUriList().add("http://" + host + ":" + port);
        }
        serverUri.setUsername(null != userName ? userName : "");
        serverUri.setPassword(null != passwd ? passwd : "");
        return serverUri;
    }

    private static ESServerUri getESServerUri(Object esloginfo) {
        ESServerUri serverUri = new ESServerUri();
        String userName = null;
        String passwd = null;
        for (Object o : (ArrayList)esloginfo) {
            LinkedHashMap key = (LinkedHashMap)o;
            String host = (String)key.get("host");
            String port = (String)key.get("port");
            userName = (String)key.get("userName");
            passwd = Encrypters.decode((String)((String)key.get("passwd")));
            serverUri.getUriList().add("http://" + host + ":" + port);
        }
        serverUri.setUsername(null != userName ? userName : "");
        serverUri.setPassword(null != passwd ? passwd : "");
        return serverUri;
    }
}

