/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.service.elasticsearch.split;

import com.google.gson.JsonObject;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.GetMapping;
import java.text.MessageFormat;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskNodeEnum;
import kd.bos.archive.exception.ExceptionUtil;
import kd.bos.archive.mq.ArchiveLogPublish;
import kd.bos.archive.task.config.ESConfiguration;
import kd.bos.archive.task.service.SplitTaskServiceAbst;
import kd.bos.archive.task.service.elasticsearch.IndexNameUtil;

public class SplitEsStructureCheckService
extends SplitTaskServiceAbst {
    private ESConfiguration configuration;

    public SplitEsStructureCheckService(ArchiveSplitTaskEntity splitTaskEntity, ESConfiguration configuration) {
        super(splitTaskEntity, ArchiveTaskNodeEnum.TBSTRUCTCHK);
        this.configuration = configuration;
    }

    @Override
    public boolean doArchive() throws Exception {
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsStructureCheckService doArchive begin,entitynumber:{0}, splitTaskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        String indexName = IndexNameUtil.getTableIndex(this.configuration, String.valueOf(this.splitTaskEntity.getIndex()), false);
        String archiveName = IndexNameUtil.getTableIndex(this.configuration, String.valueOf(this.splitTaskEntity.getIndex()), true);
        boolean isIndicesExists = this.configuration.getEsArchiveClient().indicesExists(archiveName);
        if (!isIndicesExists) {
            GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).build();
            Object getMappingResult = this.configuration.getEsClient().execute(getMapping);
            JsonObject obj = getMappingResult.getJsonObject().get(indexName).getAsJsonObject().get("mappings").getAsJsonObject();
            CreateIndex createIndex = new CreateIndex.Builder(archiveName).mappings(obj.toString()).build();
            Object jestResult = this.configuration.getEsArchiveClient().execute(createIndex);
            if (!jestResult.isSucceeded()) {
                this.configuration.getEsArchiveClient().deleteIndex(archiveName);
                String error = MessageFormat.format("ArchiveTaskHandler SplitEsStructureCheckService doArchive Failed,entitynumber:{0}, taskId:{1}, errorinfo:{2}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId(), jestResult.getErrorMessage());
                ArchiveUtil.logInfo(error);
                ArchiveLogPublish.get().publishLog(this.splitTaskEntity.getId(), this.splitTaskEntity.getEntitynumber(), error, this.getProgressType());
                throw ExceptionUtil.asRuntimeException(new RuntimeException(error));
            }
        }
        ArchiveUtil.logInfo(MessageFormat.format("ArchiveTaskHandler SplitEsStructureCheckService doArchive  end,entitynumber:{0}, taskId:{1}", this.splitTaskEntity.getEntitynumber(), this.splitTaskEntity.getId()));
        return false;
    }
}

