/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.task.config.BaseConfiguration;
import kd.bos.archive.task.taskgroup.Writer;
import kd.bos.archive.transport.exchanger.RecordReceiver;
import kd.bos.archive.transport.record.Record;
import kd.bos.archive.transport.record.RowRecord;

public abstract class WriterAbst
implements Writer {
    protected BaseConfiguration configuration;
    protected IProgress progress;
    protected int bufferSize;

    public WriterAbst(BaseConfiguration configuration, IProgress progress) {
        this.configuration = configuration;
        this.progress = progress;
        this.bufferSize = ArchiveConstant.INSERT_PAGE_SIZE;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void startWrite(RecordReceiver recordReceiver) throws SQLException {
        Record record;
        ArrayList<RowRecord> writerBuffer = new ArrayList<RowRecord>(this.bufferSize);
        while ((record = recordReceiver.getFromReader()) != null && !Thread.currentThread().isInterrupted()) {
            writerBuffer.add((RowRecord)record);
            if (writerBuffer.size() < this.bufferSize) continue;
            this.doBatchInsert(writerBuffer);
            writerBuffer.clear();
        }
        if (!writerBuffer.isEmpty()) {
            this.doBatchInsert(writerBuffer);
            writerBuffer.clear();
        }
    }

    protected abstract void doBatchInsert(List<RowRecord> var1) throws SQLException;
}

