/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.pk;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.ArchiveConstant;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.Reader;
import kd.bos.archive.transport.exchanger.RecordSender;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.tablemanager.PkTypeEnum;

public class PkReverseDbReader
implements Reader {
    private DBConfiguration configuration;
    private Object lastPk;
    private PkTypeEnum pkTypeEnum;

    public PkReverseDbReader(DBConfiguration configuration, Object lastPk) {
        this.configuration = configuration;
        this.lastPk = lastPk;
        this.pkTypeEnum = ArchiveUtil.getPkTypeEnum(configuration.getEntitynumber());
    }

    @Override
    public void startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        Object fromPK = this.lastPk;
        do {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            StringBuilder sql = new StringBuilder(128);
            sql.append(" select top ").append(ArchiveConstant.PAGE_SIZE).append(" fbillid from t_cbs_archi_reverse_mvrcd ");
            sql.append(" where ftaskid = ? ");
            ArrayList<Object> paramList = new ArrayList<Object>(1);
            paramList.add(this.configuration.getTaskEntity().getId());
            if (fromPK != null) {
                sql.append(" and fbillid > ? ");
                paramList.add(fromPK.toString());
            }
            sql.append(" order by fbillid ");
            String s = ArchiveUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"PkReverseDbReader", (DBRoute)DBRoute.base, (String)s, (Object[])paramList.toArray());){
                for (Row row : dataSet) {
                    RowRecord rowRecord = new RowRecord(1);
                    Object pkValue = row.get(0);
                    if (this.pkTypeEnum == PkTypeEnum.pk_long) {
                        pkValue = Long.parseLong(pkValue.toString());
                    }
                    fromPK = pkValue;
                    rowRecord.setPk(pkValue);
                    rowRecord.setColumn(0, pkValue);
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= ArchiveConstant.PAGE_SIZE);
    }
}

