/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.pk;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.tablemanager.TableManager;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.archive.ArchiveName;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.db.archive.config.MainArchiveConfig;
import kd.bos.xdb.tablemanager.TableName;

public class PkSplitWriter
extends DBWriterAbst {
    private ArchiveSplitTaskEntity splitTaskEntity;
    private int loop = 0;

    public PkSplitWriter(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration, IProgress progress) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        ArchiveName mainTN = ArchiveName.of((String)this.configuration.getMainTable());
        String splitMainMvTable = mainTN.getArchivePkmTable((long)this.splitTaskEntity.getSeq());
        int size = writerBuffer.size();
        Object fromPk = writerBuffer.get(0).getPk();
        Object lastPk = writerBuffer.get(size - 1).getPk();
        List paramsList = writerBuffer.stream().map(RowRecord::getPkAndIndex).collect(Collectors.toList());
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        if (DBType.MySQL == this.dbType) {
            sql.append("replace into ").append(splitMainMvTable).append("(fid, findex) values(?, ?)");
        } else {
            if (this.progress.isNeedDel()) {
                this.deleteDuplicate(splitMainMvTable, "fid", writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList()));
            }
            sql.append("insert into ").append(splitMainMvTable).append("(fid, findex) values(?, ?)");
        }
        DB.executeBatch((DBRoute)this.configuration.getFromRoute(), (String)ArchiveUtil.wrapSQL(sql.toString(), true, true), paramsList);
        for (ArchiveConfig archiveConfig : this.configuration.getSortKey()) {
            boolean isExist;
            String shardTable;
            ArchiveConfig key = archiveConfig;
            if (key == this.configuration.getMainArchiveConfig()) continue;
            String entryPKField = key.getPrimaryKey();
            ChildrenArchiveConfig childrenConfig = (ChildrenArchiveConfig)key;
            ArchiveName entryTN = ArchiveName.of((String)childrenConfig.getTable());
            String entryPkmTable = entryTN.getArchivePkmTable((long)this.splitTaskEntity.getSeq());
            ArchiveConfig parentConfig = childrenConfig.getParent();
            boolean isFirstLevel = parentConfig instanceof MainArchiveConfig;
            String joinField = childrenConfig.getJoinField();
            boolean isArchive = this.configuration.getTaskEntity().getTasktype() != ArchiveTaskTypeEnum.UNARCHIVE;
            boolean isShardHandle = this.configuration.isXdb() && isArchive;
            String oriTable = childrenConfig.getTable();
            String logicTable = childrenConfig.getLogicTable();
            String string = isShardHandle ? TableName.of((String)oriTable).getShardingTable((long)this.splitTaskEntity.getIndex()) : (shardTable = isArchive ? oriTable : logicTable);
            if (isShardHandle && !(isExist = TableManager.get().existTable(this.configuration.getFromRoute(), shardTable))) continue;
            sql.setLength(0);
            sql.append("/*dialect*/");
            sql.append("/*XDB:NO_SHARDING*/");
            sql.append("insert into ").append(entryPkmTable).append("(findex,fid,fbillid)");
            sql.append(" select ").append(this.splitTaskEntity.getIndex()).append(", C.").append(entryPKField);
            if (isFirstLevel) {
                sql.append(", C.").append(joinField);
                sql.append(" from ").append(splitMainMvTable).append(" A");
                sql.append(" inner join ").append(shardTable).append(" C on A.FID=C.").append(joinField);
                sql.append(" where A.FID >= ? and A.FID <=?");
            } else {
                String parentTable = ArchiveName.of((String)parentConfig.getTable()).getArchivePkmTable((long)this.splitTaskEntity.getSeq());
                sql.append(", A.fbillid");
                sql.append(" from ").append(parentTable).append(" A").append(" inner join ").append(shardTable).append(" C on A.FID=C.").append(joinField);
                sql.append(" where A.fbillid >= ? and A.fbillid <=?");
            }
            DB.execute((DBRoute)this.configuration.getFromRoute(), (String)sql.toString(), (Object[])new Object[]{fromPk, lastPk});
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setProgressDesc_1(BosRes.get((String)"bos-archive", (String)"ArchivePkInsertService_5", (String)"pk intermediate table data generation:fromPK={0}, toPK={1}, pks={2}", (Object[])new Object[]{fromPk, lastPk, size}));
        this.progress.setToPk(lastPk);
        this.progress.store();
    }
}

