/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.runner;

import kd.bos.archive.task.enums.State;
import kd.bos.archive.task.taskgroup.communication.Communication;

public abstract class AbstractRunner {
    private long taskId;
    private Communication runnerCommunication;

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public Communication getRunnerCommunication() {
        return this.runnerCommunication;
    }

    public void setRunnerCommunication(Communication runnerCommunication) {
        this.runnerCommunication = runnerCommunication;
    }

    public void mark(State state) {
        this.runnerCommunication.setState(state);
    }

    public void markSuccsess() {
        this.mark(State.SUCCEEDED);
    }

    public void markFailed(Throwable throwable) {
        if (State.FAILED != this.runnerCommunication.getState()) {
            this.mark(State.FAILED);
            this.runnerCommunication.setThrowable(throwable);
            this.runnerCommunication.setTimestamp(System.currentTimeMillis());
        }
    }

    protected abstract void shutDown();
}

