/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.task.taskgroup.split;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.archive.ArchiveUtil;
import kd.bos.archive.entity.ArchiveSplitTaskEntity;
import kd.bos.archive.enums.ArchiveTaskTypeEnum;
import kd.bos.archive.progress.IProgress;
import kd.bos.archive.task.config.DBConfiguration;
import kd.bos.archive.task.taskgroup.DBWriterAbst;
import kd.bos.archive.transport.record.RowRecord;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ChildrenArchiveConfig;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.tablemanager.TableName;

public class CrossDataWriter
extends DBWriterAbst {
    private DBConfiguration configuration;
    private ArchiveSplitTaskEntity splitTaskEntity;
    private ArchiveConfig config;
    private String shardTable;
    private String pkField;
    private boolean isLang;
    private boolean isReplace;
    private String columnFields;
    private String crossInsetSql;
    private boolean isShardHandle;
    private boolean unArchive;
    private int loop = 0;

    public CrossDataWriter(ArchiveSplitTaskEntity splitTaskEntity, DBConfiguration configuration, ArchiveConfig config, String columnFields, IProgress progress) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.configuration = configuration;
        this.config = config;
        this.columnFields = columnFields;
        this.pkField = config.getPrimaryKey();
        this.isLang = config instanceof ChildrenArchiveConfig && ((ChildrenArchiveConfig)config).isLangTableConfig();
        this.unArchive = this.configuration.getTaskEntity().getTasktype() == ArchiveTaskTypeEnum.UNARCHIVE;
        this.isShardHandle = this.configuration.isXdb() && this.unArchive;
        boolean bl = this.isReplace = DBType.MySQL == this.dbType;
        if (this.isShardHandle && this.config == this.configuration.getMainArchiveConfig()) {
            this.isReplace = false;
        }
        this.shardTable = this.isShardHandle && this.config != this.configuration.getMainArchiveConfig() ? TableName.of((String)config.getTable()).getShardingTable((long)splitTaskEntity.getIndex()) : (this.unArchive ? config.getTable() : config.getLogicTable());
        this.crossInsetSql = this.getCrossInsetSql(this.columnFields, this.shardTable);
        this.crossInsetSql = this.isShardHandle && this.config == this.configuration.getMainArchiveConfig() ? ArchiveUtil.wrapSQL(this.crossInsetSql, false, false) : ArchiveUtil.wrapSQL(this.crossInsetSql, true, true);
        if (this.isShardHandle) {
            try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"CrossDataWriter.createShardingTable");
                 Cache cc = CacheContext.get().createExecutorCache();){
                DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.configuration.getToRoute(), (boolean)false, () -> {
                    if (!XDBConfig.getTableManager().existTable(this.shardTable)) {
                        XDBConfig.getTableManager().createShardingTable(this.shardTable, (long)splitTaskEntity.getIndex());
                    }
                    return null;
                });
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        StringBuilder sql = new StringBuilder(128);
        sql.setLength(0);
        if (!this.isReplace && (this.progress.isNeedDel() || this.isLang && this.existsPK(this.configuration.getToRoute(), this.shardTable, this.pkField, fromPK))) {
            List<Object> pks = this.isLang ? writerBuffer.stream().map(RowRecord::getPkId).collect(Collectors.toList()) : writerBuffer.stream().map(RowRecord::getPk).collect(Collectors.toList());
            List<List> splitList = this.deleteSplitList(pks);
            for (List range : splitList) {
                SqlBuilder delSqlBuilder = new SqlBuilder();
                if (!this.isShardHandle || this.config != this.configuration.getMainArchiveConfig()) {
                    delSqlBuilder.append("/*dialect*/", new Object[0]);
                    delSqlBuilder.append("/*XDB:NO_SHARDING*/", new Object[0]);
                }
                delSqlBuilder.append("delete from ", new Object[0]).append(this.shardTable, new Object[0]);
                if (this.isLang) {
                    delSqlBuilder.append(" where ", new Object[0]).appendIn("fpkid", range);
                } else {
                    delSqlBuilder.append(" where ", new Object[0]).appendIn(this.pkField, range);
                }
                ArchiveUtil.wrapSqlBuilderExecute(this.configuration.getToRoute(), delSqlBuilder);
            }
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_2", (String)"Abnormal recovery of cross-database data migration, clear abnormal data, mvtable:{0},index={1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.shardTable, this.splitTaskEntity.getIndex(), fromPK, toPK, bufferSize}));
            this.progress.setExecSql(sql.toString());
            this.progress.store();
        }
        List fieldValuesList = writerBuffer.stream().map(RowRecord::getColumns).collect(Collectors.toList());
        DB.executeBatch((DBRoute)this.configuration.getToRoute(), (String)this.crossInsetSql, fieldValuesList);
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-archive", (String)"CrossMoveWork_3", (String)"Cross-database migration, mvtable:{0},index={1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.shardTable, this.splitTaskEntity.getIndex(), fromPK, toPK, bufferSize}));
        this.progress.setExecSql(sql.toString());
        this.progress.setToPk(toPK);
        this.progress.store();
    }

    private String getCrossInsetSql(String fieldsString, String shardTable) {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (this.isReplace) {
            sql.append("replace into ").append(shardTable);
        } else {
            sql.append("insert into ").append(shardTable);
        }
        sql.append(" (").append(fieldsString).append(") values (");
        int n = fieldsString.split(",").length;
        for (int i = 0; i < n; ++i) {
            sql.append("?");
            if (i == n - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }
}

