/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.archive.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.archive.ArchiveLogable;
import kd.bos.context.OperationContextCreator;
import kd.bos.context.RequestContext;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public class Accounts
implements ArchiveLogable {
    private static List<RequestContext> rcList = new CopyOnWriteArrayList<RequestContext>();

    public static List<RequestContext> getAccountRequestContext() {
        return rcList;
    }

    static {
        List allAccounts = new ArrayList();
        try {
            allAccounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception e) {
            log.error("ScheduleService getAllAccountsOfCurrentEnv failed: " + e.getMessage(), (Throwable)e);
        }
        for (Account account : allAccounts) {
            RequestContext rc = RequestContext.create((boolean)false);
            rc.setAccountId(account.getAccountId());
            rc.setTenantId(account.getTenantId());
            rcList.add(rc);
        }
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            RequestContext rc = RequestContext.create((boolean)false);
                            rc.setTenantId(tenantListenerInfo.getTenantnumber());
                            rc.setAccountId(account.getAccountId());
                            rcList.add(rc);
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    ArchiveLogable.log.error("TenantListener onTenantAccountsAdded failed: " + e.getMessage(), (Throwable)e);
                }
            }

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            Iterator it = rcList.iterator();
                            while (it.hasNext()) {
                                RequestContext requestContext = (RequestContext)it.next();
                                if (!requestContext.getAccountId().equals(account.getAccountId()) || !requestContext.getTenantId().equals(tenantListenerInfo.getTenantnumber())) continue;
                                it.remove();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    ArchiveLogable.log.error("TenantListener onTenantAccountsRemoved failed: " + e.getMessage(), (Throwable)e);
                }
            }

            public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            ThreadPools.executeOnce((String)"ArchiveService.initArchiveDB", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> {
                                RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
                                try {
                                    AutoCloseable ignored = rc.setupThreadRequestContext();
                                    Throwable throwable = null;
                                    if (ignored != null) {
                                        if (throwable != null) {
                                            try {
                                                ignored.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        } else {
                                            ignored.close();
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    ArchiveLogable.log.error("ArchiveService.initArchiveDB failed: " + e.getMessage(), (Throwable)e);
                                }
                            }));
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    ArchiveLogable.log.error("TenantListener onTenantChanged failed: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

