/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.excelpreview;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.excelpreview.storage.ExcelPreviewStorageFactory;
import kd.bos.excelpreview.utils.ZipOptUtils;
import kd.bos.exception.KDException;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.fileservice.utils.WatermarkUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ExcelPreviewFilter
implements Filter {
    private static final String EXCEL_PREVIEW_ROOT_PATH = "/excelpreview/";
    private static final String WATERMARK = "watermark";
    private static final Log log = LogFactory.getLog(ExcelPreviewFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        block28: {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rep = (HttpServletResponse)response;
            String url = req.getRequestURL().toString();
            if (StringUtils.isNotEmpty((String)url) && url.contains(EXCEL_PREVIEW_ROOT_PATH)) {
                String contentTypeStr = "";
                InputStream redisCache = null;
                InputStream iconInputStream = null;
                try {
                    String id;
                    String[] part;
                    String[] tempStrArr;
                    if (url.contains("stylesheet.css")) {
                        String[] split = url.split("/");
                        int length = split.length;
                        String styleSheetPath = split[length - 3] + "/" + split[length - 2] + "/" + split[length - 1];
                        tempStrArr = new String[]{"", styleSheetPath};
                    } else {
                        tempStrArr = url.contains(EXCEL_PREVIEW_ROOT_PATH + TAUtil.getAccountId() + "/") ? url.split(EXCEL_PREVIEW_ROOT_PATH + TAUtil.getAccountId() + "/") : url.split(EXCEL_PREVIEW_ROOT_PATH);
                    }
                    if (tempStrArr.length <= 1) break block28;
                    String tempStr = tempStrArr[1];
                    int firstIndex = tempStr.indexOf(47);
                    String fileName = tempStr.substring(firstIndex + 1);
                    if (fileName.contains("&")) {
                        fileName = fileName.substring(0, fileName.indexOf(38));
                    }
                    if ((part = (id = tempStr.substring(0, firstIndex)).split("-")).length > 2 && !url.endsWith("css")) {
                        String appId = part[0];
                        String entityNum = part[1];
                        long currUserId = RequestContext.get().getCurrUserId();
                        HashSet<String> permSet = new HashSet<String>();
                        String permItem = "2NJ5VA7D2ONF";
                        permSet.add(permItem);
                        Class<?> aClass = Class.forName("kd.bos.servicehelper.permission.PermissionServiceHelper");
                        Method hasViewPermissionMethod = aClass.getMethod("checkMultiPermItemInfos", Long.TYPE, String.class, Set.class);
                        Map permMap = (Map)hasViewPermissionMethod.invoke(null, currUserId, entityNum, permSet);
                        if (!((Boolean)permMap.get(permItem)).booleanValue()) {
                            contentTypeStr = "application/json; charset=utf-8";
                            HashMap<String, String> result = new HashMap<String, String>();
                            result.put("status", "error");
                            result.put("description", "You don't have permission to this file.");
                            this.writeResponse(rep, contentTypeStr, new ByteArrayInputStream(JSONUtils.toString(result).getBytes()));
                            return;
                        }
                    }
                    if (fileName.endsWith(".js")) {
                        contentTypeStr = "text/javascript";
                    } else if (fileName.endsWith(".css")) {
                        contentTypeStr = "text/css";
                    } else if (fileName.endsWith(".html")) {
                        contentTypeStr = "text/html; charset=gb2312";
                    } else if (fileName.endsWith(".htm")) {
                        contentTypeStr = "text/html; charset=gb2312";
                    } else if (fileName.endsWith(".png")) {
                        contentTypeStr = "image/png";
                    }
                    redisCache = ExcelPreviewStorageFactory.getRedisStorage().getInputStream(id);
                    InputStream htmlInputStream = ZipOptUtils.getInputStreamByFilePath(redisCache, Charset.forName("utf-8"), fileName);
                    if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
                        String iconStr;
                        try {
                            iconInputStream = ExcelPreviewStorageFactory.getRedisStorage().getInputStream(id + WATERMARK);
                        }
                        catch (KDException e) {
                            log.warn("this time do not print watermark", (Throwable)e);
                        }
                        if (iconInputStream != null && FileServiceConfig.PREVIEW_WATERMARK_EXCEL_ENABLE.getBoolean() && StringUtils.isNotEmpty((String)(iconStr = WatermarkUtil.iconHtmlStr((InputStream)iconInputStream)))) {
                            this.writeResponse(rep, contentTypeStr, htmlInputStream, iconStr);
                            return;
                        }
                    }
                    this.writeResponse(rep, contentTypeStr, htmlInputStream);
                }
                catch (Exception e) {
                    log.error("File preview failed.", (Throwable)e);
                    contentTypeStr = "application/json; charset=utf-8";
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("status", "error");
                    result.put("description", "File preview failed.");
                    this.writeResponse(rep, contentTypeStr, new ByteArrayInputStream(JSONUtils.toString(result).getBytes()));
                }
                finally {
                    if (redisCache != null) {
                        redisCache.close();
                    }
                    if (iconInputStream != null) {
                        iconInputStream.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpServletResponse rep, String contentTypeStr, InputStream inputStream) throws IOException {
        OutputStream out = null;
        try {
            if (inputStream != null) {
                rep.setHeader("Content-Type", contentTypeStr);
                out = rep.getOutputStream();
                byte[] buffer = new byte[8192];
                int len = 0;
                while ((len = inputStream.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpServletResponse rep, String contentTypeStr, InputStream inputStream, String iconStr) throws IOException {
        OutputStream out = null;
        try {
            if (inputStream != null) {
                String line;
                rep.setHeader("Content-Type", contentTypeStr);
                out = rep.getOutputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("GBK")));
                boolean added = false;
                while ((line = reader.readLine()) != null) {
                    if (!added && "</head>".equals(line.trim())) {
                        added = true;
                        line = System.getProperty("line.separator") + iconStr + System.getProperty("line.separator") + "</head>";
                    }
                    out.write(line.getBytes(Charset.forName("GBK")));
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

