/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.excelpreview;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.excelpreview.storage.ExcelPreviewStorageFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.excelpreview.ExcelPreview;
import kd.bos.fileservice.utils.TAUtil;
import kd.bos.session.SessionKeys;
import kd.bos.url.UrlService;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class ExcelPreviewServiceImpl
implements ExcelPreview {
    private static final String STATUS = "status";
    private static final int TIMEOUT = 7200;
    private static final String EXCELPREVIEWROOTPATH = "/excelpreview/";
    private static final String WATERMARK = "watermark";

    public Map<String, Object> preview(String id, InputStream in) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String basePath = UrlService.getDomainContextUrl();
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)basePath)) {
            result.put(STATUS, "error");
            result.put("description", "param can not be null! id=" + id + ", basePath=" + basePath);
        } else {
            try {
                String filePath;
                if (basePath.endsWith("/")) {
                    basePath = basePath.substring(0, basePath.length() - 1);
                }
                String queryString = RequestContext.get().getQueryString();
                String[] parameters = queryString.split("&");
                HashMap<String, String> parameterMap = new HashMap<String, String>(4);
                for (String parameter : parameters) {
                    String[] part = parameter.split("=");
                    parameterMap.put(part[0], part[1]);
                }
                String appId = (String)parameterMap.get("appId");
                String fId = (String)parameterMap.get("fId");
                StringBuilder sb = new StringBuilder(32);
                if (StringUtils.isNotEmpty((String)appId) && StringUtils.isNotEmpty((String)fId)) {
                    sb.append(appId).append("-").append(fId).append("-").append(id);
                } else {
                    sb.append(id);
                }
                String authId = sb.toString();
                ExcelPreviewStorageFactory.getRedisStorage().storage(authId, in, 7200);
                String fileName = id + ".html";
                if (SessionKeys.isAccountSession((String)TAUtil.getTenantId()) && ConfigurationUtil.getBoolean((String)"fileserver.excelpreview.pathwithaccount", (Boolean)true).booleanValue()) {
                    String accountId = TAUtil.getAccountId();
                    filePath = basePath + EXCELPREVIEWROOTPATH + accountId + "/" + authId + "/" + fileName;
                } else {
                    filePath = basePath + EXCELPREVIEWROOTPATH + authId + "/" + fileName;
                }
                result.put("url", filePath);
                result.put(STATUS, "success");
                result.put("id", authId);
            }
            catch (Exception e) {
                result.put(STATUS, "error");
                result.put("description", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return result;
    }

    public void remove(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new KDException(BosErrorCode.previewFailed, new Object[]{"param(id) can not be null!+ id=" + id});
        }
        ExcelPreviewStorageFactory.getRedisStorage().remove(id);
    }

    public void addWartermarkData(String id, InputStream iconStream) {
        if (iconStream != null) {
            ExcelPreviewStorageFactory.getRedisStorage().storage(id + WATERMARK, iconStream, 7200);
        }
    }
}

