/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.excelpreview.storage;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.excelpreview.storage.ExcelPreviewStorage;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.ExceptionUtils;

public class RedisExcelPreviewStorage
implements ExcelPreviewStorage {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tempfile", new DistributeCacheHAPolicy(true, false));

    @Override
    public InputStream getInputStream(String id) {
        if (cache.contains(id)) {
            byte[] values = cache.getByteValue(id);
            if (values.length <= 0) {
                return null;
            }
            return new ByteArrayInputStream(values);
        }
        throw new KDException(BosErrorCode.redisRead, new Object[]{"the key is not exist (key=" + id + ")"});
    }

    @Override
    public void storage(String id, InputStream inputStream, int timeOut) {
        try {
            cache.put(id, ByteStreams.toByteArray((InputStream)inputStream), timeOut);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "key:" + id + " exception:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e), (Throwable)e);
        }
    }

    @Override
    public void remove(String id) {
        cache.remove(id);
    }
}

