/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.internal.DefaultResponseDataWrapper;
import kd.bos.api.internal.MessageInbound;
import kd.bos.api.internal.MessageOutbound;
import kd.bos.thread.ThreadLifeCycleListener;
import kd.bos.thread.ThreadLifeCycleManager;

public class ApiRequestContext
implements AutoCloseable {
    private static final String JSON = "text/json";
    private static final String UTF8 = "UTF-8";
    static Set<String> headercontenttypejson;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private MessageInbound inbound;
    private MessageOutbound outbound;
    private static ThreadLocal<ApiRequestContext> t;

    static void setContentTypeJson(HttpServletResponse resp) {
        resp.setCharacterEncoding(UTF8);
        resp.setContentType(JSON);
        String api_contenttype_json = System.getProperty("api.contenttype.json");
        if (api_contenttype_json != null && !api_contenttype_json.isEmpty() && headercontenttypejson.contains(api_contenttype_json)) {
            resp.setContentType(api_contenttype_json);
        }
    }

    public ApiRequestContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.inbound = new MessageInbound(request);
        this.outbound = new MessageOutbound(response, DefaultResponseDataWrapper.instance);
    }

    public ApiRequestContext(HttpServletRequest request, HttpServletResponse response, MessageInbound inbound, MessageOutbound outbound) {
        this.request = request;
        this.response = response;
        this.inbound = inbound;
        this.outbound = outbound;
    }

    public String getParameterValue(String param) {
        return this.request.getParameter(param);
    }

    public Map<String, String> getParameterMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        Map map = this.request.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            String value = values == null ? null : values[0];
            result.put(key, value);
        }
        return result;
    }

    public String getHeaderValue(String header) {
        return this.request.getHeader(header);
    }

    public String getPostData() {
        return this.inbound.getBody();
    }

    public <T> T getPostData(Class<T> clazz) {
        return this.inbound.getBody(clazz);
    }

    public void writeSuccess() {
        this.writeSuccess(null, null);
    }

    public void writeSuccess(Object object) {
        this.writeSuccess(object, object.getClass());
    }

    public <T> void writeSuccess(Object object, Class<T> clazz) {
        ApiRequestContext.setContentTypeJson(this.response);
        this.outbound.writeSuccess(object, clazz);
    }

    public void writeError(String errorCode, String errorMessage) {
        ApiRequestContext.setContentTypeJson(this.response);
        this.outbound.writeError(errorCode, errorMessage);
    }

    @Override
    public void close() {
        this.inbound.close();
        this.outbound.close();
    }

    public static void initThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        ApiRequestContext context = new ApiRequestContext(request, response);
        t.set(context);
    }

    public static ApiRequestContext get() {
        return t.get();
    }

    public static void clear() {
        ApiRequestContext c = ApiRequestContext.get();
        if (c != null) {
            c.close();
            t.remove();
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    static {
        ThreadLifeCycleManager.addListener((ThreadLifeCycleListener)new ThreadLifeCycleListener(){

            public void start() {
            }

            public void end() {
                ApiRequestContext.clear();
            }
        }, (int)0);
        headercontenttypejson = new HashSet<String>();
        headercontenttypejson.add("application/json");
        headercontenttypejson.add(JSON);
        t = new ThreadLocal();
    }
}

