/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.client.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.api.Probe;
import kd.bos.api.client.ApiCallback;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class DefaultApiClient
extends ApiClient {
    private static Log logger = LogFactory.getLog(DefaultApiClient.class);
    private HttpClient client;
    private ApiClient.Option option;

    protected DefaultApiClient() {
        this(null);
    }

    protected DefaultApiClient(ApiClient.Option option) {
        this.option = option == null ? new ApiClient.Option() : option;
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.option.connectTimeout).setConnectTimeout(this.option.readTimeout).build()).build();
    }

    public ApiClient.Option getOption() {
        return this.option;
    }

    protected ApiRequest wrapRequest(ApiRequest request) {
        return request;
    }

    protected ApiResult wrapResult(ApiResult result) {
        return result;
    }

    @Override
    public ApiResult execute(ApiRequest request) {
        request = this.wrapRequest(request);
        ApiResult result = this._execute(request);
        return this.wrapResult(result);
    }

    private ApiResult _execute(ApiRequest request) {
        switch (request.getMethod()) {
            case POST: {
                return this.post(request);
            }
            case GET: {
                return this.get(request);
            }
        }
        return null;
    }

    protected String completeUrl(String url) {
        return url;
    }

    private String buildUrl(ApiRequest request) {
        HashMap<String, String> map = request.getParameters();
        if (map == null) {
            return request.getUrl();
        }
        try {
            URIBuilder builder = new URIBuilder(this.completeUrl(request.getUrl()));
            for (Map.Entry entry : map.entrySet()) {
                builder.addParameter((String)entry.getKey(), (String)entry.getValue());
            }
            return builder.toString();
        }
        catch (URISyntaxException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiCommon, new Object[0]);
        }
    }

    private void buildHeader(ApiRequest request, HttpUriRequest get) {
        StringBuilder cookieValue = new StringBuilder();
        HashMap<String, String> map = request.getCookies();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                cookieValue.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(";");
            }
        }
        if ((map = request.getHeaders()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (!"Cookie".equals(key)) {
                    get.addHeader(key, (String)entry.getValue());
                    continue;
                }
                cookieValue.append((String)entry.getValue());
            }
        }
        if (cookieValue.length() > 0) {
            get.addHeader("Cookie", cookieValue.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult get(ApiRequest request) {
        String url = this.buildUrl(request);
        HttpGet get = new HttpGet(url);
        this.buildHeader(request, (HttpUriRequest)get);
        try {
            Probe.touch((String)"http");
            HttpResponse response = this.client.execute((HttpUriRequest)get);
            ApiResult apiResult = this.buildResult("GET", url, response);
            return apiResult;
        }
        catch (Exception e) {
            this.logError("GET", url, e);
            ApiResult apiResult = this.buildResult(e);
            return apiResult;
        }
    }

    private void logError(String method, String url, Throwable t) {
        if ("GET".equalsIgnoreCase(method) && url != null) {
            String[] sp = url.split("\\?");
            url = sp[0];
        }
        logger.error("Error in http client '" + method + "' call of url:" + url, t);
    }

    private void get(ApiRequest request, ApiCallback callback) {
        String url = this.buildUrl(request);
        HttpGet get = new HttpGet(url);
        this.buildHeader(request, (HttpUriRequest)get);
        this.asynCall("GET", url, (HttpUriRequest)get, callback);
    }

    private ApiResult buildResult(Exception e) {
        return new ApiResult(e);
    }

    private Map<String, String> buildHeaderMap(Header[] headers) {
        HashMap<String, String> map = new HashMap<String, String>(headers.length);
        for (Header header : headers) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    private ApiResult buildResult(String method, String url, HttpResponse response) {
        ApiResult result = null;
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity resEntity = response.getEntity();
            try {
                String data = EntityUtils.toString((HttpEntity)resEntity);
                result = new ApiResult(data);
            }
            catch (IOException e) {
                this.logError(method, url, e);
                result = this.buildResult(e);
            }
        } else {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                this.logError(method, url, e);
            }
            return new ApiResult((Throwable)new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            result.setHeaders(this.buildHeaderMap(headers));
        }
        return result;
    }

    private void post(ApiRequest request, ApiCallback callback) {
        String url = this.completeUrl(request.getUrl());
        HttpPost post = new HttpPost(url);
        this.buildHeader(request, (HttpUriRequest)post);
        StringEntity entity = new StringEntity(request.getPostData(), request.getContentType());
        post.setEntity((HttpEntity)entity);
        this.asynCall("POST", url, (HttpUriRequest)post, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynCall(final String method, final String url, HttpUriRequest r, final ApiCallback callback) {
        try {
            Probe.touch((String)"http");
            this.client.execute(r, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    callback.response(DefaultApiClient.this.buildResult(method, url, response));
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logError(method, url, e);
            callback.response(new ApiResult(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult post(ApiRequest request) {
        String url = this.completeUrl(request.getUrl());
        HttpPost post = new HttpPost(url);
        this.buildHeader(request, (HttpUriRequest)post);
        StringEntity entity = new StringEntity(request.getPostData(), request.getContentType());
        post.setEntity((HttpEntity)entity);
        try {
            Probe.touch((String)"http");
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            ApiResult apiResult = this.buildResult("POST", url, response);
            return apiResult;
        }
        catch (Exception e) {
            this.logError("POST", url, e);
            ApiResult apiResult = this.buildResult(e);
            return apiResult;
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            HttpClientUtils.closeQuietly((HttpClient)this.client);
        }
    }

    @Override
    public void asynExecute(ApiRequest request, final ApiCallback callback) {
        request = this.wrapRequest(request);
        this._asynExecute(request, new ApiCallback(){

            @Override
            public void response(ApiResult result) {
                result = DefaultApiClient.this.wrapResult(result);
                callback.response(result);
            }
        });
    }

    private void _asynExecute(ApiRequest request, ApiCallback apiCallback) {
        switch (request.getMethod()) {
            case POST: {
                this.post(request, apiCallback);
                break;
            }
            case GET: {
                this.get(request, apiCallback);
                break;
            }
        }
    }
}

