/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.api.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletResponse;
import kd.bos.api.internal.ResponseDataWrapper;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageOutbound
implements AutoCloseable {
    private OutputStreamWriter writer;
    private ResponseDataWrapper wrapper;
    private static final Logger logger = LoggerFactory.getLogger(MessageOutbound.class);

    public MessageOutbound(HttpServletResponse response, ResponseDataWrapper wrapper) {
        this.wrapper = wrapper;
        try {
            this.writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
        }
    }

    public <T> void writeSuccess(Object object, Class<T> clazz) {
        if (this.writer == null) {
            throw new KDException(BosErrorCode.apiIO, new Object[]{"OutputStream is closed."});
        }
        String data = this.wrapper.wrapSuccess(object);
        this.writeOut(data);
    }

    public void writeError(String errorCode, String errorMessage) {
        if (this.writer == null) {
            throw new KDException(BosErrorCode.apiIO, new Object[]{"OutputStream is closed."});
        }
        String data = null;
        data = this.wrapper != null ? this.wrapper.wrapError(errorCode, errorMessage) : errorCode + ":" + errorMessage;
        this.writeOut(data);
    }

    private void writeOut(String data) {
        try {
            this.writer.write(data);
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.apiIO, new Object[]{e.getMessage()});
        }
        finally {
            this.writer = null;
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.writer = null;
        }
    }
}

