/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.circuitbreaker.hystirx;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.concurrent.Callable;
import kd.bos.bundle.BosRes;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class BosHystrixCommand<T>
extends HystrixCommand<T> {
    private Callable<T> callable = null;

    public BosHystrixCommand(String groupKey, String commandKey, Callable<T> callable) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)));
        this.callable = callable;
    }

    protected T run() {
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.circuitBreakFallback, new Object[]{e});
        }
    }

    protected T getFallback() {
        throw new KDException(BosErrorCode.circuitBreakFallback, new Object[]{BosRes.get((String)"bos-mservice-hystrix", (String)"BosHystrixCommand_0", (String)"\u9650\u6d41\u63a7\u5236:\u8bf7\u6c42\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Object[])new Object[0])});
    }
}

