/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.circuitbreaker.hystirx;

import java.util.concurrent.Callable;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.circuitbreaker.hystirx.BosHystrixCommand;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;

public class HystrixCircuitbreaker
implements Circuitbreaker {
    private static final String EXCLUDE_INTERFACE = "hystrix.command.default.exclude.interface";
    private String name = null;

    public Circuitbreaker withName(String name) {
        this.name = name;
        return this;
    }

    public Circuitbreaker withParams(Object ... objects) {
        return this;
    }

    public void setContent(String s) {
    }

    public void setContent(String s, String s1) {
    }

    public Circuitbreaker begin() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> callable) {
        String commandKey = this.getCommandKey(this.name);
        if (this.isExcludeInterface(commandKey)) {
            try {
                T t = callable.call();
                return t;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.circuitBreak, new Object[]{"Hystrix call exception,commandKey=" + commandKey + e.getMessage()});
            }
            finally {
                this.end();
            }
        }
        try {
            BosHystrixCommand<T> cmd = new BosHystrixCommand<T>(this.getGroupKey(this.name), commandKey, callable);
            Object object = cmd.execute();
            return (T)object;
        }
        finally {
            this.end();
        }
    }

    public void end() {
    }

    private String getGroupKey(String name) {
        String groupKey = "Bos-GroupKey";
        if (null == name || "".equals(name)) {
            return groupKey;
        }
        if (name.contains("/")) {
            groupKey = name.substring(0, name.lastIndexOf(47));
        } else if (name.contains(".")) {
            groupKey = name.substring(0, name.lastIndexOf(46));
        } else if (name.contains("#")) {
            groupKey = name.substring(0, name.lastIndexOf(35));
        }
        return groupKey;
    }

    private String getCommandKey(String name) {
        String commandKey = "Bos-CommandKey";
        if (null == name || "".equals(name)) {
            return commandKey;
        }
        if (name.contains("/")) {
            commandKey = name.substring(name.lastIndexOf("/"));
            if (commandKey.contains(".do")) {
                commandKey = commandKey.substring(0, commandKey.lastIndexOf("."));
            }
        } else if (name.contains(".")) {
            commandKey = name.substring(name.lastIndexOf("."));
        } else if (name.contains("#")) {
            commandKey = name.substring(name.lastIndexOf("#"));
        }
        return commandKey;
    }

    private boolean isExcludeInterface(String commandKey) {
        String excludeInterface = System.getProperty(EXCLUDE_INTERFACE);
        return excludeInterface != null && excludeInterface.contains(commandKey);
    }
}

