/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class DevFindClassForInject {
    private static final String[] paths = "C:/biz-dev/mservice/lib,C:/bos-evn-dev/mservice/lib,C:/bos-evn-main/mservice/lib".split(",");

    DevFindClassForInject() {
    }

    private static void findClassForInject(Class<?> cls) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        HashSet<String> foundSet = new HashSet<String>();
        HashSet<String> foundedJars = new HashSet<String>();
        ArrayList<String> foundList = new ArrayList<String>();
        ArrayList<String> withSuperList = new ArrayList<String>();
        for (String path : paths) {
            File root = new File(path);
            for (File f : root.listFiles()) {
                if (f.isDirectory()) {
                    File[] listFiles;
                    for (File jarFile : listFiles = f.listFiles(pathname -> pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar"))) {
                        DevFindClassForInject.findClassesInJar(cls, jarFile, cl, foundSet, foundList, withSuperList, foundedJars);
                    }
                    continue;
                }
                if (!f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar")) continue;
                DevFindClassForInject.findClassesInJar(cls, f, cl, foundSet, foundList, withSuperList, foundedJars);
            }
        }
        for (String string : foundList) {
        }
    }

    private static void findClassesInJar(Class<?> cls, File jarFile, ClassLoader cl, Set<String> foundSet, List<String> foundList, List<String> withSuperList, Set<String> foundedJars) throws IOException {
        String jarFileName = jarFile.getName();
        if (foundedJars.contains(jarFileName)) {
            return;
        }
        foundedJars.add(jarFileName);
        try (JarFile jar = new JarFile(jarFile);){
            DevFindClassForInject.consumerClassesInJar(jar, name -> {
                try {
                    withSuperList.clear();
                    for (Class<?> c = Class.forName(name, false, cl); c != null && !foundSet.contains(c.getName()) && DevFindClassForInject.isTheRightClass(cls, c); c = c.getSuperclass()) {
                        String cname = c.getName();
                        foundSet.add(cname);
                        withSuperList.add(cname);
                    }
                    if (!withSuperList.isEmpty()) {
                        for (int i = withSuperList.size() - 1; i >= 0; --i) {
                            foundList.add((String)withSuperList.get(i));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
        }
    }

    private static void consumerClassesInJar(JarFile jar, Function<String, Object> consumer) {
        Enumeration<JarEntry> em = jar.entries();
        while (em.hasMoreElements()) {
            String name;
            JarEntry entry = em.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            name = name.substring(0, name.length() - 6).replace('/', '.');
            consumer.apply(name);
        }
    }

    private static boolean isTheRightClass(Class<?> cls, Class<?> c) {
        return !c.isInterface() && cls.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers());
    }
}

