/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDSecurityManager;

public final class KDReflection {
    private static final int SECURITYMANAGER_CLASSCONTEXT_CALLER_FROMINDEX = 3;
    private static final int THROWABLE_STACK_CALLER_FROMINDEX = 2;

    public static boolean isEnableSecurity() {
        return KDSecurityManager.enableSecurity;
    }

    public static SecurityException securityException(String msg) {
        throw new SecurityException(msg);
    }

    public static boolean isCustomerClass(Class<?> cls) {
        return KDSecurityManager.isCustomerClass(cls.getName());
    }

    public static boolean isCustomerClass(String className) {
        return KDSecurityManager.isCustomerClass(className);
    }

    public static Class<?> getCallerClass() {
        return KDSecurityManager.get().getClassContext()[3];
    }

    public static KDCallerInfo getCallerClassUntilNot(Class<?> ... untils) {
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 3; i < n; ++i) {
            boolean find = true;
            Class<?> cls = classes[i];
            for (Class<?> until : untils) {
                if (cls != until) continue;
                find = false;
                break;
            }
            if (!find) continue;
            return new KDCallerInfo(cls, i - 1);
        }
        return null;
    }

    public static KDCallerInfo getCallerClassUntilNot(String ... untils) {
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 3; i < n; ++i) {
            boolean find = true;
            String clsName = classes[i].getName();
            for (String until : untils) {
                if (!clsName.equals(until)) continue;
                find = false;
                break;
            }
            if (!find) continue;
            return new KDCallerInfo(classes[i], i - 1);
        }
        return null;
    }

    static KDCallerInfo getCallerClassUntilNotAssignableFrom(Class<?> untilAssignableFrom) {
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 3; i < n; ++i) {
            Class<?> cls = classes[i];
            if (untilAssignableFrom.isAssignableFrom(cls)) continue;
            return new KDCallerInfo(cls, i - 1);
        }
        return null;
    }

    static boolean isInflationCreateClassLoader() {
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 3; i < n; ++i) {
            String clsName = classes[i].getName();
            if (!clsName.startsWith("java.") && !clsName.startsWith("sun.")) {
                return false;
            }
            if (!"sun.reflect.DelegatingClassLoader".equals(clsName)) continue;
            return true;
        }
        return false;
    }

    static boolean isInflationSuppressAccess() {
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 3; i < n; ++i) {
            String clsName = classes[i].getName();
            if (!clsName.startsWith("java.") && !clsName.startsWith("sun.")) {
                return false;
            }
            if (!"sun.reflect.MethodAccessorGenerator".equals(clsName)) continue;
            return true;
        }
        return false;
    }

    static Class<?> getCallerCallerClass() {
        return KDSecurityManager.get().getClassContext()[4];
    }

    public static Class<?> getCallerClass(int callStackDepth) {
        return KDSecurityManager.get().getClassContext()[callStackDepth];
    }

    public static String getCallerMethodName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        if ("invoke0".contentEquals(methodName) && "sun.reflect.NativeMethodAccessorImpl".equals(stackTrace[2].getClassName())) {
            return stackTrace[6].getMethodName();
        }
        return new Throwable().getStackTrace()[2].getMethodName();
    }

    static String getCallerCallerMethodName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        if ("invoke0".contentEquals(methodName) && "sun.reflect.NativeMethodAccessorImpl".equals(stackTrace[2].getClassName())) {
            return stackTrace[7].getMethodName();
        }
        return new Throwable().getStackTrace()[3].getMethodName();
    }

    public static String getCallerMethodName(int callStackDepth) {
        return new Throwable().getStackTrace()[callStackDepth].getMethodName();
    }

    public static void forbidCustomerNewDriver(Class<?> driverClass) {
        Class<?> caller = null;
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 4; i < n; ++i) {
            Class<?> cls = classes[i];
            String clsName = cls.getName();
            if (cls == driverClass || clsName.startsWith("java.") || clsName.startsWith("sun.")) continue;
            caller = cls;
            break;
        }
        if (caller != null && KDReflection.isCustomerClass(caller)) {
            throw new SecurityException("\u7981\u6b62\u521b\u5efaDriver\uff1a" + driverClass);
        }
    }

    public static void forbidCustomerDataSourceGetConnection(Class<?> driverClass) {
        Class<?> caller = null;
        Class<?>[] classes = KDSecurityManager.get().getClassContext();
        int n = classes.length;
        for (int i = 4; i < n; ++i) {
            Class<?> cls = classes[i];
            String clsName = cls.getName();
            if (cls == driverClass || clsName.startsWith("java.") || clsName.startsWith("sun.")) continue;
            caller = cls;
            break;
        }
        if (caller != null && KDReflection.isCustomerClass(caller)) {
            throw new SecurityException("\u7981\u6b62\u521b\u5efaDataSource\uff1a" + driverClass);
        }
    }
}

