/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import kd.bos.security.InjectResources;
import kd.bos.security.KDReflection;

public interface KDSecurityDataSource {
    public static final String datasource_constructor_check_code = "checkDataSourceSecurityCall();";

    default public void checkDataSourceSecurityCall() {
        KDReflection.forbidCustomerDataSourceGetConnection(this.getClass());
    }

    public static Callable<Object> injectDataSources() throws Throwable {
        ArrayList<CtClass> toFrozenList = new ArrayList<CtClass>(InjectResources.datasources.length);
        ClassPool pool = ClassPool.getDefault();
        CtClass interfaceCls = pool.getCtClass(KDSecurityDataSource.class.getName());
        for (String datasource : InjectResources.datasources) {
            if (KDReflection.isCustomerClass(datasource)) continue;
            try {
                CtClass cls = pool.getCtClass(datasource);
                toFrozenList.add(cls);
                cls.addInterface(interfaceCls);
                for (CtConstructor cc : cls.getConstructors()) {
                    cc.insertAfter(datasource_constructor_check_code);
                }
            }
            catch (NotFoundException notFoundException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return () -> {
            for (CtClass cls : toFrozenList) {
                if (cls.isFrozen()) continue;
                try {
                    cls.toClass();
                }
                catch (Exception exception) {}
            }
            return null;
        };
    }
}

