/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.security.PermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionManager {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionManager.class);
    private static final String CUS_PATH_DEFAULT = "/mservice/lib/cus/";
    public static final String PERM_CHECK_ENABLE_KEY = "permission.check.cus.enable";
    private static final String PERM_CHECK_ENABLE_DEFAULT = "false";
    public static final String PERM_CHECK_WARN_KEY = "permission.check.cus.warn";
    private static final String PERM_CHECK_WARN_DEFAULT = "true";
    public static final int MAX_SIZE = 200000;
    private static CopyOnWriteArrayList<String> CUS_CLASS_LIST = new CopyOnWriteArrayList();

    public static void load() {
        if (!PermissionManager.permCheckEnable().booleanValue()) {
            return;
        }
        new Thread(() -> {
            File[] listOfFiles;
            File folder = new File(CUS_PATH_DEFAULT);
            if (folder.exists() && (listOfFiles = folder.listFiles()) != null) {
                HashSet<String> classSet = new HashSet<String>();
                boolean isBreakLoop = false;
                block11: for (File file : listOfFiles) {
                    if (isBreakLoop) break;
                    if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file.getPath());
                        Enumeration<JarEntry> e = jarFile.entries();
                        while (e.hasMoreElements()) {
                            JarEntry je = e.nextElement();
                            if (je.isDirectory() || !je.getName().endsWith(".class") || je.getName().endsWith(".class") && je.getName().contains("$")) continue;
                            String className = je.getName().substring(0, je.getName().length() - 6);
                            className = className.replace('/', '.');
                            classSet.add(className);
                            if (classSet.size() < 200000) continue;
                            isBreakLoop = true;
                            continue block11;
                        }
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage());
                    }
                    finally {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {
                                LOG.error(e.getMessage());
                            }
                        }
                    }
                }
                if (classSet.size() > 0) {
                    CUS_CLASS_LIST.addAll(classSet);
                }
            }
        }).start();
    }

    public static void check() {
        if (!PermissionManager.permCheckEnable().booleanValue()) {
            return;
        }
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String className = stackTraceElements[3].getClassName();
        if (CUS_CLASS_LIST.contains(className)) {
            String msg = "No permission to access. " + stackTraceElements[2].getClassName();
            if (PermissionManager.permCheckWarn().booleanValue()) {
                LOG.warn(msg);
                return;
            }
            LOG.error(msg);
            throw new PermissionException(msg);
        }
    }

    private static Boolean permCheckEnable() {
        return Boolean.parseBoolean(System.getProperty(PERM_CHECK_ENABLE_KEY, PERM_CHECK_ENABLE_DEFAULT));
    }

    private static Boolean permCheckWarn() {
        return Boolean.parseBoolean(System.getProperty(PERM_CHECK_WARN_KEY, PERM_CHECK_WARN_DEFAULT));
    }
}

